/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.actions.GitAddOperation;
import git4idea.index.actions.StagingAreaOperationActionKt;
import git4idea.index.ui.GitStageTreeKt;
import git4idea.index.ui.NodeKind;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lgit4idea/index/actions/GitStageAllActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "kinds", "", "Lgit4idea/index/ui/NodeKind;", "([Lgit4idea/index/ui/NodeKind;)V", "getKinds", "()[Lgit4idea/index/ui/NodeKind;", "[Lgit4idea/index/ui/NodeKind;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
public abstract class GitStageAllActionBase
extends DumbAwareAction {
    @NotNull
    private final NodeKind[] kinds;

    public GitStageAllActionBase(NodeKind ... kinds) {
        Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
        this.kinds = kinds;
    }

    @NotNull
    public final NodeKind[] getKinds() {
        return this.kinds;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !GitStageManagerKt.isStagingAreaAvailable(project)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        NodeKind[] nodeKindArray = this.kinds;
        e.getPresentation().setEnabled(GitStageTreeKt.hasMatchingRoots(GitStageTracker.Companion.getInstance(project).getState(), Arrays.copyOf(nodeKindArray, nodeKindArray.length)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        NodeKind[] nodeKindArray = this.kinds;
        StagingAreaOperationActionKt.performStageOperation(project2, GitStageTreeKt.fileStatusNodes(GitStageTracker.Companion.getInstance(project2).getState(), Arrays.copyOf(nodeKindArray, nodeKindArray.length)), GitAddOperation.INSTANCE);
    }
}

