/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitIndexUtil {
    private static final Logger LOG = Logger.getInstance(GitIndexUtil.class);
    private static final String EXECUTABLE_MODE = "100755";
    private static final String DEFAULT_MODE = "100644";

    @Nullable
    public static StagedFile listStaged(@NotNull GitRepository repository, @NotNull FilePath filePath) throws VcsException {
        List<StagedFile> result2 = GitIndexUtil.listStaged(repository, Collections.singleton(filePath));
        if (result2.size() != 1) {
            return null;
        }
        return result2.get(0);
    }

    @NotNull
    public static List<StagedFile> listStaged(@NotNull GitRepository repository, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        return GitIndexUtil.listStaged(project, root, filePaths);
    }

    @NotNull
    public static List<StagedFile> listStaged(@NotNull Project project, final @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        final ArrayList<StagedFile> result2 = new ArrayList<StagedFile>();
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.addParameters("-s");
        h.endOptions();
        h.addRelativePaths(filePaths);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListFilesStagedRecord(root, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        return result2;
    }

    @Nullable
    public static StagedFile listTree(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) throws VcsException {
        List<StagedFileOrDirectory> result2 = GitIndexUtil.listTree(repository, Collections.singleton(filePath), revision);
        if (result2.size() != 1 || !(result2.get(0) instanceof StagedFile)) {
            return null;
        }
        return (StagedFile)result2.get(0);
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTree(@NotNull GitRepository repository, @NotNull Collection<? extends FilePath> filePaths, @NotNull VcsRevisionNumber revision) throws VcsException {
        ArrayList<StagedFileOrDirectory> result2 = new ArrayList<StagedFileOrDirectory>();
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)repository.getRoot(), filePaths)) {
            result2.addAll(GitIndexUtil.listTreeForRawPaths(repository, paths, revision));
        }
        return result2;
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTreeForRawPaths(@NotNull GitRepository repository, @NotNull List<String> filePaths, @NotNull VcsRevisionNumber revision) throws VcsException {
        final ArrayList<StagedFileOrDirectory> result2 = new ArrayList<StagedFileOrDirectory>();
        final VirtualFile root = repository.getRoot();
        GitLineHandler h = new GitLineHandler(repository.getProject(), root, GitCommand.LS_TREE);
        h.addParameters(revision.asString());
        h.endOptions();
        h.addParameters(filePaths);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListTreeRecord(root, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        return result2;
    }

    @Nullable
    private static StagedFile parseListFilesStagedRecord(@NotNull VirtualFile root, @NotNull String line) {
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String hash = s.spaceToken();
            String stage = s.tabToken();
            String filePath = s.line();
            if (!"0".equals(stage)) {
                return null;
            }
            FilePath path = VcsUtil.getFilePath((VirtualFile)root, (String)GitUtil.unescapePath(filePath));
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(path, hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static StagedFileOrDirectory parseListTreeRecord(@NotNull VirtualFile root, @NotNull String line) {
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String type = s.spaceToken();
            String hash = s.tabToken();
            String filePath = GitUtil.unescapePath(s.line());
            if ("tree".equals(type)) {
                return new StagedDirectory(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true));
            }
            if ("commit".equals(type)) {
                return new StagedSubrepo(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true), hash);
            }
            if (!"blob".equals(type)) {
                return null;
            }
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(VcsUtil.getFilePath((VirtualFile)root, (String)filePath), hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Hash loadStagedSubmoduleHash(@NotNull GitRepository submodule, @NotNull GitRepository parentRepo) throws VcsException {
        GitLineHandler h = new GitLineHandler(parentRepo.getProject(), parentRepo.getRoot(), GitCommand.SUBMODULE);
        h.addParameters("status", "--cached");
        h.addRelativeFiles(Collections.singletonList(submodule.getRoot()));
        String out = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(out);
        s.skipChars(1);
        String hash = s.spaceToken();
        return HashImpl.build((String)hash);
    }

    @Nullable
    public static Hash loadSubmoduleHashAt(@NotNull GitRepository submodule, @NotNull GitRepository parentRepo, @NotNull VcsRevisionNumber revisionNumber) throws VcsException {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)submodule.getRoot());
        List<StagedFileOrDirectory> lsTree = GitIndexUtil.listTree(parentRepo, Collections.singletonList(filePath), revisionNumber);
        if (lsTree.size() != 1) {
            LOG.warn(String.format("Unexpected output of ls-tree command for submodule [%s] at [%s]: %s", filePath, revisionNumber, lsTree));
            return null;
        }
        StagedSubrepo tree2 = (StagedSubrepo)ObjectUtils.tryCast((Object)lsTree.get(0), StagedSubrepo.class);
        if (tree2 == null) {
            LOG.warn(String.format("Unexpected type of ls-tree for submodule [%s] at [%s]: %s", filePath, revisionNumber, tree2));
            return null;
        }
        if (!filePath.equals(tree2.getPath())) {
            LOG.warn(String.format("Submodule path [%s] doesn't match the ls-tree output path [%s]", tree2.getPath(), filePath));
            return null;
        }
        return HashImpl.build((String)tree2.getBlobHash());
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository, @NotNull FilePath filePath, byte @NotNull [] bytes, boolean executable) throws VcsException {
        return GitIndexUtil.write(repository, filePath, new ByteArrayInputStream(bytes), executable);
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable) throws VcsException {
        return GitIndexUtil.write(repository.getProject(), repository.getRoot(), filePath, content, executable);
    }

    @NotNull
    public static Hash write(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable) throws VcsException {
        return GitIndexUtil.write(project, root, filePath, content, executable, false);
    }

    @NotNull
    public static Hash write(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable, boolean addNewFiles) throws VcsException {
        Hash hash = GitIndexUtil.hashObject(project, root, filePath, content);
        GitIndexUtil.updateIndex(project, root, filePath, hash, executable, addNewFiles);
        return hash;
    }

    @NotNull
    private static Hash hashObject(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.HASH_OBJECT);
        h.setSilent(true);
        h.addParameters("-w", "--stdin");
        h.addParameters("--path");
        h.addRelativePaths(filePath);
        h.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(content));
        h.endOptions();
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        return HashImpl.build((String)output.trim());
    }

    public static void updateIndex(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull Hash blobHash, boolean isExecutable) throws VcsException {
        GitIndexUtil.updateIndex(repository.getProject(), repository.getRoot(), filePath, blobHash, isExecutable, false);
    }

    public static void updateIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash blobHash, boolean isExecutable, boolean addNewFiles) throws VcsException {
        String mode = isExecutable ? EXECUTABLE_MODE : DEFAULT_MODE;
        String path = VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.UPDATE_INDEX);
        if (addNewFiles) {
            h.addParameters("--add");
        }
        if (GitVersionSpecialty.CACHEINFO_SUPPORTS_SINGLE_PARAMETER_FORM.existsIn(project)) {
            h.addParameters("--cacheinfo", mode + "," + blobHash.asString() + "," + path);
        } else {
            h.addParameters("--cacheinfo", mode, blobHash.asString(), path);
        }
        h.endOptions();
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
    }

    public static byte @NotNull [] read(@NotNull GitRepository repository, @NotNull String blobHash) throws VcsException {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(blobHash);
        h.endOptions();
        return h.run();
    }

    public static class StagedFile
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;
        private final boolean myExecutable;

        public StagedFile(@NotNull FilePath path, @NotNull String blobHash, boolean executable) {
            super(path);
            this.myBlobHash = blobHash;
            this.myExecutable = executable;
        }

        @NotNull
        public String getBlobHash() {
            return this.myBlobHash;
        }

        public boolean isExecutable() {
            return this.myExecutable;
        }

        @Override
        @NonNls
        public String toString() {
            return "StagedFile[" + this.myPath + "] at [" + this.myBlobHash + "]";
        }
    }

    public static class StagedDirectory
    extends StagedFileOrDirectory {
        public StagedDirectory(@NotNull FilePath path) {
            super(path);
        }
    }

    public static class StagedSubrepo
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;

        public StagedSubrepo(@NotNull FilePath path, @NotNull String blobHash) {
            super(path);
            this.myBlobHash = blobHash;
        }

        @NotNull
        public String getBlobHash() {
            return this.myBlobHash;
        }

        @Override
        @NonNls
        public String toString() {
            return "StagedSubRepo[" + this.myPath + "] at [" + this.myBlobHash + "]";
        }
    }

    public static class StagedFileOrDirectory {
        @NotNull
        protected final FilePath myPath;

        public StagedFileOrDirectory(@NotNull FilePath path) {
            this.myPath = path;
        }

        @NotNull
        public FilePath getPath() {
            return this.myPath;
        }

        @NonNls
        public String toString() {
            return "StagedFileOrDirectory[" + this.myPath + "]";
        }
    }
}

