/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.util.Range;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.util.containers.PeekableIteratorWrapper;
import git4idea.index.StagedRange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/index/BlockMerger;", "", "staged", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "unstaged", "(Ljava/util/List;Ljava/util/List;)V", "dirtyEnd", "", "dirtyStagedShift", "dirtyStart", "dirtyUnstagedShift", "hasStaged", "", "hasUnstaged", "ranges", "", "Lgit4idea/index/StagedRange;", "stagedShift", "unstagedShift", "flush", "", "nextLine", "getRangeDelta", "range", "Lcom/intellij/diff/util/Range;", "handleStaged", "block", "handleUnstaged", "markDirtyRange", "start", "end", "run", "intellij.vcs.git"})
final class BlockMerger {
    @NotNull
    private final List<DocumentTracker.Block> staged;
    @NotNull
    private final List<DocumentTracker.Block> unstaged;
    @NotNull
    private final List<StagedRange> ranges;
    private int dirtyStart;
    private int dirtyEnd;
    private boolean hasStaged;
    private boolean hasUnstaged;
    private int stagedShift;
    private int unstagedShift;
    private int dirtyStagedShift;
    private int dirtyUnstagedShift;

    public BlockMerger(@NotNull List<DocumentTracker.Block> staged, @NotNull List<DocumentTracker.Block> unstaged) {
        Intrinsics.checkNotNullParameter(staged, (String)"staged");
        Intrinsics.checkNotNullParameter(unstaged, (String)"unstaged");
        this.staged = staged;
        this.unstaged = unstaged;
        this.ranges = new ArrayList();
        this.dirtyStart = -1;
        this.dirtyEnd = -1;
    }

    @NotNull
    public final List<StagedRange> run() {
        PeekableIteratorWrapper it1 = new PeekableIteratorWrapper(this.staged.iterator());
        PeekableIteratorWrapper it2 = new PeekableIteratorWrapper(this.unstaged.iterator());
        while (it1.hasNext() || it2.hasNext()) {
            if (!it2.hasNext()) {
                Object object = it1.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it1.next()");
                this.handleStaged((DocumentTracker.Block)object);
                continue;
            }
            if (!it1.hasNext()) {
                Object object = it2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it2.next()");
                this.handleUnstaged((DocumentTracker.Block)object);
                continue;
            }
            DocumentTracker.Block block1 = (DocumentTracker.Block)it1.peek();
            DocumentTracker.Block block2 = (DocumentTracker.Block)it2.peek();
            if (block1.getRange().start2 <= block2.getRange().start1) {
                Object object = it1.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it1.next()");
                this.handleStaged((DocumentTracker.Block)object);
                continue;
            }
            Object object = it2.next();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it2.next()");
            this.handleUnstaged((DocumentTracker.Block)object);
        }
        this.flush(Integer.MAX_VALUE);
        return this.ranges;
    }

    private final void handleStaged(DocumentTracker.Block block) {
        Range range = block.getRange();
        this.flush(range.start2);
        this.dirtyStagedShift -= this.getRangeDelta(range);
        this.markDirtyRange(range.start2, range.end2);
        this.hasStaged = true;
    }

    private final void handleUnstaged(DocumentTracker.Block block) {
        Range range = block.getRange();
        this.flush(range.start1);
        this.dirtyUnstagedShift += this.getRangeDelta(range);
        this.markDirtyRange(range.start1, range.end1);
        this.hasUnstaged = true;
    }

    private final void markDirtyRange(int start, int end) {
        if (this.dirtyEnd == -1) {
            this.dirtyStart = start;
            this.dirtyEnd = end;
        } else {
            this.dirtyEnd = Math.max(this.dirtyEnd, end);
        }
    }

    private final void flush(int nextLine) {
        if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
            this.ranges.add(new StagedRange(this.dirtyStart + this.unstagedShift, this.dirtyEnd + this.unstagedShift + this.dirtyUnstagedShift, this.dirtyStart, this.dirtyEnd, this.dirtyStart + this.stagedShift, this.dirtyEnd + this.stagedShift + this.dirtyStagedShift, this.hasStaged, this.hasUnstaged));
            this.dirtyStart = -1;
            this.dirtyEnd = -1;
            this.hasStaged = false;
            this.hasUnstaged = false;
            this.stagedShift += this.dirtyStagedShift;
            this.unstagedShift += this.dirtyUnstagedShift;
            this.dirtyStagedShift = 0;
            this.dirtyUnstagedShift = 0;
        }
    }

    private final int getRangeDelta(Range range) {
        int deleted = range.end1 - range.start1;
        int inserted = range.end2 - range.start2;
        return inserted - deleted;
    }
}

