/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ignore.IgnoredFileGeneratorImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.util.IgnoreFileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.io.PathKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitVcs;
import git4idea.ignore.GitIgnoreInStoreDirGenerator;
import git4idea.ignore.GitIgnoreInStoreDirGeneratorKt;
import git4idea.index.GitIndexUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0006\u0010\u0011\u001a\u00020\fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0014\u001a\u00020\u00132\u000b\u0010\u000e\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\u000b\u0010\u0017\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\u001d\u0010\u0014\u001a\u00020\u00132\u000b\u0010\u000e\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u0006\u0010\u001d\u001a\u00020\fJ \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/ignore/GitIgnoreInStoreDirGenerator;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "needGenerate", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createGitignore", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "inDir", "dispose", "", "doGenerate", "projectConfigDirPath", "Ljava/nio/file/Path;", "projectConfigDirVFile", "generateGitignoreInStoreDirIfNeeded", "haveNotGitVcs", "", "inStoreDir", "", "Lorg/jetbrains/annotations/SystemIndependent;", "path", "ignore", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "isProjectSharedInGit", "markGenerated", "registerVfsListenerIfNeeded", "run", "skipGeneration", "VfsEventsListener", "intellij.vcs.git"})
public final class GitIgnoreInStoreDirGenerator
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean needGenerate;

    public GitIgnoreInStoreDirGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.needGenerate = new AtomicBoolean(true);
    }

    public void dispose() {
    }

    public final void run() {
        boolean $i$f$runReadAction = false;
        boolean listenerRegistered = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ GitIgnoreInStoreDirGenerator this$0;
            {
                this.this$0 = gitIgnoreInStoreDirGenerator;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(GitIgnoreInStoreDirGenerator.access$registerVfsListenerIfNeeded(this.this$0));
            }
        });
        if (!listenerRegistered) {
            this.generateGitignoreInStoreDirIfNeeded();
        }
    }

    private final boolean registerVfsListenerIfNeeded() {
        boolean needRegister;
        Path projectConfigDirPath = ProjectKt.getStateStore((Project)this.project).getDirectoryStorePath();
        if (projectConfigDirPath == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir path not found. Project is default or not directory based.");
            this.needGenerate.set(false);
            return false;
        }
        VirtualFile projectConfigDirVFile = LocalFileSystem.getInstance().findFileByNioFile(projectConfigDirPath);
        if (projectConfigDirVFile != null && !IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile((Project)this.project, (VirtualFile)projectConfigDirVFile)) {
            this.needGenerate.set(false);
            return false;
        }
        boolean bl = needRegister = projectConfigDirVFile == null;
        if (needRegister) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().debug("Project config directory doesn't exist. Register VFS listener and try generate .gitignore after config directory become available.");
            AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)new VfsEventsListener(this.project), (Disposable)this);
        }
        return needRegister;
    }

    public final void generateGitignoreInStoreDirIfNeeded() {
        if (!this.needGenerate.compareAndSet(true, false)) {
            return;
        }
        Path projectConfigDirPath = ProjectKt.getStateStore((Project)this.project).getDirectoryStorePath();
        if (projectConfigDirPath == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir path not found. Project is default or not directory based.");
            return;
        }
        VirtualFile projectConfigDirVFile = LocalFileSystem.getInstance().findFileByNioFile(projectConfigDirPath);
        if (projectConfigDirVFile == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir not found in VFS by path " + projectConfigDirPath);
            return;
        }
        if (this.skipGeneration(this.project, projectConfigDirVFile, projectConfigDirPath)) {
            return;
        }
        this.doGenerate(this.project, projectConfigDirPath, projectConfigDirVFile);
    }

    private final boolean skipGeneration(Project project, VirtualFile projectConfigDirVFile, Path projectConfigDirPath) {
        if (!IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile((Project)project, (VirtualFile)projectConfigDirVFile)) {
            this.needGenerate.set(false);
            return true;
        }
        if (VfsUtil.refreshAndFindChild((VirtualFile)projectConfigDirVFile, (String)".gitignore") != null) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        if (this.haveNotGitVcs(project, projectConfigDirPath)) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        if (this.isProjectSharedInGit(project)) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void doGenerate(Project project, Path projectConfigDirPath, VirtualFile projectConfigDirVFile) {
        VcsKey gitVcsKey = GitVcs.getKey();
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider((Project)project, (VcsKey)gitVcsKey);
        if (ignoredFileContentProvider == null) {
            return;
        }
        IgnoredFileContentProvider gitIgnoreContentProvider = ignoredFileContentProvider;
        GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().debug("Generate .gitignore in " + projectConfigDirPath + " for " + gitVcsKey.getName());
        VirtualFile gitIgnoreFile = this.createGitignore(projectConfigDirVFile);
        for (IgnoredFileProvider ignoredFileProvider : IgnoredFileProvider.IGNORE_FILE.getExtensionList()) {
            String ignoredGroupDescription;
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            Set set = ignoredFileProvider.getIgnoredFiles(project);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ignoredFileProvider.getIgnoredFiles(project)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IgnoredFileDescriptor ignore = (IgnoredFileDescriptor)element$iv$iv;
                boolean bl = false;
                String string = PathKt.getSystemIndependentPath((Path)projectConfigDirPath);
                Intrinsics.checkNotNullExpressionValue((Object)ignore, (String)"ignore");
                if (!this.inStoreDir(string, ignore)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            IgnoredFileDescriptor[] ignoresInStoreDir = thisCollection$iv.toArray(new IgnoredFileDescriptor[0]);
            if (ignoresInStoreDir.length == 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)gitIgnoreContentProvider.buildIgnoreGroupDescription(ignoredFileProvider), (String)"gitIgnoreContentProvider\u2026tion(ignoredFileProvider)");
            IgnoreFileUtilKt.addNewElementsToIgnoreBlock((Project)project, (VirtualFile)gitIgnoreFile, (String)ignoredGroupDescription, (VcsKey)gitVcsKey, (IgnoredFileDescriptor[])Arrays.copyOf(ignoresInStoreDir, ignoresInStoreDir.length));
        }
        this.markGenerated(project, projectConfigDirVFile);
    }

    private final boolean haveNotGitVcs(Project project, Path projectConfigDirPath) {
        FilePath filePath = VcsUtil.getFilePath((File)projectConfigDirPath.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(projectConfigDirPath.toFile())");
        FilePath projectConfigDir = filePath;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)projectConfigDir);
        if (abstractVcs == null) {
            return false;
        }
        AbstractVcs vcs = abstractVcs;
        return !Intrinsics.areEqual((Object)vcs.getKeyInstanceMethod(), (Object)GitVcs.getKey());
    }

    private final boolean isProjectSharedInGit(Project project) {
        boolean bl;
        Object object = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
        if (object == null || (object = PathKt.getSystemIndependentPath((Path)object)) == null) {
            return false;
        }
        Object storeDir = object;
        FilePath filePath = VcsUtil.getFilePath((String)storeDir);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(storeDir)");
        FilePath storeDirPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)storeDirPath);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vcsRoot = virtualFile;
        try {
            List<GitIndexUtil.StagedFile> list2 = GitIndexUtil.listStaged(project, vcsRoot, CollectionsKt.listOf((Object)storeDirPath));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"listStaged(project, vcsRoot, listOf(storeDirPath))");
            bl = !((Collection)list2).isEmpty();
        }
        catch (VcsException e) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().debug("Cannot check staged files in " + (String)storeDir, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final void markGenerated(Project project, VirtualFile projectConfigDirVFile) {
        IgnoredFileGeneratorImpl.markIgnoreFileRootAsGenerated((Project)project, (String)projectConfigDirVFile.getPath());
        this.needGenerate.set(false);
    }

    private final VirtualFile createGitignore(VirtualFile inDir) {
        Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<VirtualFile>(inDir){
            final /* synthetic */ VirtualFile $inDir;
            {
                this.$inDir = $inDir;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                VirtualFile virtualFile = this.$inDir;
                boolean $i$f$runWriteAction = false;
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction(new Computable(virtualFile){
                    final /* synthetic */ VirtualFile $inDir$inlined;
                    {
                        this.$inDir$inlined = virtualFile;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.$inDir$inlined.createChildData((Object)this.$inDir$inlined, ".gitignore");
                    }
                });
            }
        }), (int)1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inDir: VirtualFile) =\n  \u2026ata(inDir, GITIGNORE) } }");
        return (VirtualFile)object;
    }

    private final boolean inStoreDir(String projectConfigDirPath, IgnoredFileDescriptor ignore) {
        String string = ignore.getPath();
        if (string == null) {
            return false;
        }
        String path = string;
        return this.inStoreDir(projectConfigDirPath, path);
    }

    private final boolean inStoreDir(String projectConfigDirPath, String path) {
        return FileUtil.isAncestor((String)projectConfigDirPath, (String)path, (boolean)true);
    }

    public static final /* synthetic */ boolean access$registerVfsListenerIfNeeded(GitIgnoreInStoreDirGenerator $this) {
        return $this.registerVfsListenerIfNeeded();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/ignore/GitIgnoreInStoreDirGenerator$VfsEventsListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/ignore/GitIgnoreInStoreDirGenerator;Lcom/intellij/openapi/project/Project;)V", "affectedFilesInStoreDir", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "filesChanged", "", "intellij.vcs.git"})
    private final class VfsEventsListener
    implements AsyncVfsEventsListener {
        @NotNull
        private final Project project;

        public VfsEventsListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void filesChanged(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (!GitIgnoreInStoreDirGenerator.this.needGenerate.get() || this.project.isDisposed()) {
                return;
            }
            if (this.affectedFilesInStoreDir(events)) {
                GitIgnoreInStoreDirGenerator.this.generateGitignoreInStoreDirIfNeeded();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean affectedFilesInStoreDir(List<? extends VFileEvent> events) {
            boolean bl;
            void $this$any$iv;
            Path path = ProjectKt.getStateStore((Project)this.project).getDirectoryStorePath();
            Object object = path;
            if (path == null) return false;
            if ((object = PathKt.getSystemIndependentPath((Path)object)) == null) {
                return false;
            }
            Object projectConfigDirPath = object;
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)affectedFilesInStoreDir.1.INSTANCE), (Function1)affectedFilesInStoreDir.2.INSTANCE);
            GitIgnoreInStoreDirGenerator gitIgnoreInStoreDirGenerator = GitIgnoreInStoreDirGenerator.this;
            boolean $i$f$any = false;
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                VirtualFile file2 = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (file2.exists()) {
                    String string = file2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                    if (gitIgnoreInStoreDirGenerator.inStoreDir((String)projectConfigDirPath, string)) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }
    }
}

