/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecord {
    private static final Logger LOG = Logger.getInstance(GitLogRecord.class);
    @NotNull
    protected final Map<GitLogParser.GitLogOption, String> myOptions;
    protected final boolean mySupportsRawBody;
    protected GitHandler myHandler;

    GitLogRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, boolean supportsRawBody) {
        this.myOptions = options;
        this.mySupportsRawBody = supportsRawBody;
    }

    @NotNull
    private String lookup(@NotNull GitLogParser.GitLogOption key) {
        String value = this.myOptions.get((Object)key);
        if (value == null) {
            LOG.error("Missing value for option " + key + ", while executing " + this.myHandler);
            return "";
        }
        return value;
    }

    @NotNull
    String getHash() {
        return this.lookup(GitLogParser.GitLogOption.HASH);
    }

    @NotNull
    String getTreeHash() {
        return this.lookup(GitLogParser.GitLogOption.TREE);
    }

    @NotNull
    String getAuthorName() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_NAME);
    }

    @NotNull
    String getAuthorEmail() {
        return this.lookup(GitLogParser.GitLogOption.AUTHOR_EMAIL);
    }

    @NotNull
    String getCommitterName() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_NAME);
    }

    @NotNull
    String getCommitterEmail() {
        return this.lookup(GitLogParser.GitLogOption.COMMITTER_EMAIL);
    }

    @NotNull
    String getSubject() {
        return this.lookup(GitLogParser.GitLogOption.SUBJECT);
    }

    @NotNull
    String getBody() {
        return this.lookup(GitLogParser.GitLogOption.BODY);
    }

    @NotNull
    String getRawBody() {
        return this.lookup(GitLogParser.GitLogOption.RAW_BODY);
    }

    @NotNull
    String getShortenedRefLog() {
        return this.lookup(GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR);
    }

    @NotNull
    Date getDate() {
        return new Date(this.getCommitTime());
    }

    long getCommitTime() {
        try {
            return GitLogUtil.parseTime(this.myOptions.get((Object)GitLogParser.GitLogOption.COMMIT_TIME));
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get commit time from " + this + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    long getAuthorTimeStamp() {
        try {
            return GitLogUtil.parseTime(this.myOptions.get((Object)GitLogParser.GitLogOption.AUTHOR_TIME));
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get author time from " + this + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    String getFullMessage() {
        return ((String)(this.mySupportsRawBody ? this.getRawBody() : this.getSubject() + "\n\n" + this.getBody())).stripTrailing();
    }

    String @NotNull [] getParentsHashes() {
        String parents = this.lookup(GitLogParser.GitLogOption.PARENTS);
        if (parents.trim().length() == 0) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return parents.split(" ");
    }

    @NotNull
    public Collection<String> getRefs() {
        String decorate = this.myOptions.get((Object)GitLogParser.GitLogOption.REF_NAMES);
        return GitLogRecord.parseRefNames(decorate);
    }

    @NotNull
    public Map<GitLogParser.GitLogOption, String> getOptions() {
        return this.myOptions;
    }

    public boolean isSupportsRawBody() {
        return this.mySupportsRawBody;
    }

    @NotNull
    private static List<String> parseRefNames(@Nullable String decoration) {
        if (decoration == null) {
            return ContainerUtil.emptyList();
        }
        int startParentheses = decoration.indexOf("(");
        int endParentheses = decoration.lastIndexOf(")");
        if (startParentheses == -1 || endParentheses == -1) {
            return Collections.emptyList();
        }
        String refs = decoration.substring(startParentheses + 1, endParentheses);
        String[] names = refs.split(", ");
        ArrayList<String> result2 = new ArrayList<String>();
        for (String item : names) {
            String POINTER = " -> ";
            if (item.contains(" -> ")) {
                List parts = StringUtil.split((String)item, (String)" -> ");
                result2.addAll(ContainerUtil.map((Collection)parts, String::trim));
                continue;
            }
            int colon = item.indexOf(58);
            String raw = colon > 0 ? item.substring(colon + 1).trim() : item;
            result2.add(raw);
        }
        return result2;
    }

    public void setUsedHandler(GitHandler handler) {
        this.myHandler = handler;
    }

    @NonNls
    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.mySupportsRawBody, this.myHandler);
    }
}

