/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.GitLogParser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/history/GitLogHistoryHandler;", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getRename", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler$Rename;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "beforeHash", "Lcom/intellij/vcs/log/Hash;", "afterHash", "Companion", "RenamesCollector", "intellij.vcs.git"})
public final class GitLogHistoryHandler
implements VcsLogFileHistoryHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public GitLogHistoryHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public VcsLogFileHistoryHandler.Rename getRename(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash beforeHash, @NotNull Hash afterHash) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)beforeHash, (String)"beforeHash");
        Intrinsics.checkNotNullParameter((Object)afterHash, (String)"afterHash");
        GitLineHandler h = new GitLineHandler(this.project, root, GitCommand.DIFF);
        h.setWithMediator(false);
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"-M", "--diff-filter=R", "--name-status", "--encoding=UTF-8", "--follow", beforeHash.asString() + ".." + afterHash.asString()};
        h.addParameters(stringArray);
        h.endOptions();
        stringArray = new FilePath[]{filePath};
        h.addRelativePaths((FilePath[])stringArray);
        String string = h.printableCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"h.printableCommandLine()");
        RenamesCollector renamesCollector = new RenamesCollector(string);
        h.addLineListener(renamesCollector.getLineListener());
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        VcsFileStatusInfo vcsFileStatusInfo = renamesCollector.getSingleRename();
        if (vcsFileStatusInfo != null) {
            VcsFileStatusInfo info = vcsFileStatusInfo;
            boolean bl = false;
            FilePath filePath2 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getFirstPath()), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(root.path + \u2026 + info.firstPath, false)");
            FilePath firstPath = filePath2;
            FilePath filePath3 = VcsUtil.getFilePath((String)(root.getPath() + "/" + info.getSecondPath()), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)filePath3, (String)"getFilePath(root.path + \u2026+ info.secondPath, false)");
            FilePath secondPath = filePath3;
            return new VcsLogFileHistoryHandler.Rename(firstPath, secondPath, beforeHash, afterHash);
        }
        return null;
    }

    static {
        Logger logger = Logger.getInstance(GitLogHistoryHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(GitLogHistoryHandler::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/history/GitLogHistoryHandler$RenamesCollector;", "Lgit4idea/history/DefaultGitLogFullRecordBuilder;", "commandLine", "", "(Lgit4idea/history/GitLogHistoryHandler;Ljava/lang/String;)V", "unexpectedStatusReported", "", "addPath", "", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "firstPath", "secondPath", "getLineListener", "Lgit4idea/commands/GitLineHandlerListener;", "getSingleRename", "Lcom/intellij/vcs/log/impl/VcsFileStatusInfo;", "intellij.vcs.git"})
    private final class RenamesCollector
    extends DefaultGitLogFullRecordBuilder {
        @NotNull
        private final String commandLine;
        private boolean unexpectedStatusReported;

        public RenamesCollector(String commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            this.commandLine = commandLine;
        }

        @Override
        public void addPath(@NotNull Change.Type type, @NotNull String firstPath, @Nullable String secondPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)firstPath, (String)"firstPath");
            if (type == Change.Type.MOVED) {
                super.addPath(type, firstPath, secondPath);
            } else if (!this.unexpectedStatusReported) {
                this.unexpectedStatusReported = true;
                LOG.error("Unexpected change " + type + " " + firstPath + " " + secondPath + " in the output of [" + this.commandLine + "]");
            }
        }

        @NotNull
        public final GitLineHandlerListener getLineListener() {
            GitLogParser.PathsParser parser = new GitLogParser.PathsParser(GitLogParser.NameStatus.STATUS, this);
            return (arg_0, arg_1) -> RenamesCollector.getLineListener$lambda$0(parser, arg_0, arg_1);
        }

        @Nullable
        public final VcsFileStatusInfo getSingleRename() {
            VcsFileStatusInfo info;
            if (this.getStatuses$intellij_vcs_git().size() > 1) {
                LOG.error("Unexpected multiple renames found. Command [" + this.commandLine + "].\nOutput [" + this.getStatuses$intellij_vcs_git() + "].");
            }
            VcsFileStatusInfo vcsFileStatusInfo = info = (VcsFileStatusInfo)CollectionsKt.singleOrNull(this.getStatuses$intellij_vcs_git());
            if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getSecondPath() : null) != null) {
                return info;
            }
            return null;
        }

        private static final void getLineListener$lambda$0(GitLogParser.PathsParser $parser, String line, Key outputType) {
            Intrinsics.checkNotNullParameter((Object)$parser, (String)"$parser");
            if (Intrinsics.areEqual((Object)outputType, (Object)ProcessOutputTypes.STDOUT)) {
                $parser.parseLine(line);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/history/GitLogHistoryHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

