/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitChangeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitChangesParser {
    private static final Logger LOG = Logger.getInstance(GitChangesParser.class);

    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<VcsFileStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) {
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (VcsFileStatusInfo statusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, statusInfo));
        }
        return result2;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull VcsFileStatusInfo statusInfo) {
        FileStatus status;
        ContentRevision before;
        String path = statusInfo.getFirstPath();
        FilePath filePath = GitContentRevision.createPath(vcsRoot, path);
        return new Change(before, switch (statusInfo.getType()) {
            case Change.Type.NEW -> {
                before = null;
                status = FileStatus.ADDED;
                yield GitContentRevision.createRevision(filePath, thisRevision, project);
            }
            case Change.Type.MODIFICATION -> {
                status = FileStatus.MODIFIED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield GitContentRevision.createRevision(filePath, thisRevision, project);
            }
            case Change.Type.DELETED -> {
                status = FileStatus.DELETED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield null;
            }
            case Change.Type.MOVED -> {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = secondPath == null ? filePath : GitContentRevision.createPath(vcsRoot, secondPath);
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield GitContentRevision.createRevision(filePathAfterRename, thisRevision, project);
            }
            default -> throw new AssertionError((Object)("Unknown file status: " + statusInfo));
        }, status);
    }

    @NotNull
    static Change.Type getChangeType(@NotNull GitChangeType type) {
        return switch (type) {
            case GitChangeType.ADDED -> Change.Type.NEW;
            case GitChangeType.TYPE_CHANGED, GitChangeType.MODIFIED -> Change.Type.MODIFICATION;
            case GitChangeType.DELETED -> Change.Type.DELETED;
            case GitChangeType.COPIED, GitChangeType.RENAMED -> Change.Type.MOVED;
            default -> {
                LOG.error("Unknown git change type: " + type);
                yield Change.Type.MODIFICATION;
            }
        };
    }
}

