/*
 * Decompiled with CFR 0.152.
 */
package git4idea.crlf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.attributes.GitAttribute;
import git4idea.attributes.GitCheckAttrParser;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitCrlfProblemsDetector {
    private static final Logger LOG = Logger.getInstance(GitCrlfProblemsDetector.class);
    private static final String CRLF = "\r\n";
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    private final boolean myShouldWarn;

    @NotNull
    public static GitCrlfProblemsDetector detect(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        return new GitCrlfProblemsDetector(project, git, files);
    }

    private GitCrlfProblemsDetector(@NotNull Project project, @NotNull Git git, @NotNull Collection<VirtualFile> files) {
        Map<VirtualFile, Collection<VirtualFile>> crlfFilesByRoots;
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
        this.myGit = git;
        Map<VirtualFile, List<VirtualFile>> filesByRoots = GitUtil.sortFilesByGitRootIgnoringMissing(project, files);
        boolean shouldWarn2 = false;
        Collection<VirtualFile> rootsWithIncorrectAutoCrlf = this.getRootsWithIncorrectAutoCrlf(filesByRoots);
        if (!rootsWithIncorrectAutoCrlf.isEmpty() && !(crlfFilesByRoots = GitCrlfProblemsDetector.findFilesWithCrlf(filesByRoots, rootsWithIncorrectAutoCrlf)).isEmpty()) {
            Map<VirtualFile, Collection<VirtualFile>> crlfFilesWithoutAttrsByRoots = this.findFilesWithoutAttrs(crlfFilesByRoots);
            shouldWarn2 = !crlfFilesWithoutAttrsByRoots.isEmpty();
        }
        this.myShouldWarn = shouldWarn2;
    }

    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithoutAttrs(Map<VirtualFile, Collection<VirtualFile>> filesByRoots) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithoutAttrsByRoot = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : filesByRoots.entrySet()) {
            Collection<VirtualFile> files;
            VirtualFile root = entry.getKey();
            Collection<VirtualFile> filesWithoutAttrs = this.findFilesWithoutAttrs(root, files = entry.getValue());
            if (filesWithoutAttrs.isEmpty()) continue;
            filesWithoutAttrsByRoot.put(root, filesWithoutAttrs);
        }
        return filesWithoutAttrsByRoot;
    }

    @NotNull
    private Collection<VirtualFile> findFilesWithoutAttrs(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            return Collections.emptyList();
        }
        List<String> interestingAttributes = Arrays.asList(GitAttribute.TEXT.getName(), GitAttribute.CRLF.getName());
        GitCommandResult result2 = this.myGit.checkAttr(repository, interestingAttributes, files);
        if (!result2.success()) {
            LOG.warn(String.format("Couldn't git check-attr. Attributes: %s, files: %s", interestingAttributes, files));
            return Collections.emptyList();
        }
        GitCheckAttrParser parser = GitCheckAttrParser.parse(result2.getOutput());
        Map<String, Collection<GitAttribute>> attributes = parser.getAttributes();
        ArrayList<VirtualFile> filesWithoutAttrs = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            ProgressIndicatorProvider.checkCanceled();
            String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)virtualFile.getPath(), (char)'/');
            Collection<GitAttribute> attrs = attributes.get(relativePath);
            if (attrs != null && (attrs.contains((Object)GitAttribute.TEXT) || attrs.contains((Object)GitAttribute.CRLF))) continue;
            filesWithoutAttrs.add(virtualFile);
        }
        return filesWithoutAttrs;
    }

    @NotNull
    private static Map<VirtualFile, Collection<VirtualFile>> findFilesWithCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> allFilesByRoots, @NotNull Collection<VirtualFile> rootsWithIncorrectAutoCrlf) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithCrlfByRoots = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : allFilesByRoots.entrySet()) {
            Collection<VirtualFile> filesWithCrlf;
            VirtualFile root = entry.getKey();
            List<VirtualFile> files = entry.getValue();
            if (!rootsWithIncorrectAutoCrlf.contains(root) || (filesWithCrlf = GitCrlfProblemsDetector.findFilesWithCrlf(files)).isEmpty()) continue;
            filesWithCrlfByRoots.put(root, filesWithCrlf);
        }
        return filesWithCrlfByRoots;
    }

    @NotNull
    private static Collection<VirtualFile> findFilesWithCrlf(@NotNull Collection<? extends VirtualFile> files) {
        ArrayList<VirtualFile> filesWithCrlf = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            ProgressIndicatorProvider.checkCanceled();
            String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile, (boolean)true);
            if (!CRLF.equals(separator)) continue;
            filesWithCrlf.add(virtualFile);
        }
        return filesWithCrlf;
    }

    @NotNull
    private Collection<VirtualFile> getRootsWithIncorrectAutoCrlf(@NotNull Map<VirtualFile, List<VirtualFile>> filesByRoots) {
        ArrayList<VirtualFile> rootsWithIncorrectAutoCrlf = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : filesByRoots.entrySet()) {
            VirtualFile root = entry.getKey();
            boolean autocrlf = this.isAutoCrlfSetRight(root);
            if (autocrlf) continue;
            rootsWithIncorrectAutoCrlf.add(root);
        }
        return rootsWithIncorrectAutoCrlf;
    }

    private boolean isAutoCrlfSetRight(@NotNull VirtualFile root) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            return true;
        }
        GitCommandResult result2 = this.myGit.config(repository, "core.autocrlf");
        String value = result2.getOutputAsJoinedString();
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("input");
    }

    public boolean shouldWarn() {
        return this.myShouldWarn;
    }
}

