/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.i18n.GitBundle;
import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J0\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil;", "", "()V", "ACTIVE_MERGE_WINDOW", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/ui/WindowWrapper;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "focusActiveMergeWindow", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasActiveMergeWindow", "hasActiveMergeWindow$intellij_vcs_git", "putActiveWindowKey", "", "project", "Lcom/intellij/openapi/project/Project;", "wrapper", "showMergeWindow", "lock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "MyMergeCallback", "MyProducer", "NotificationProvider", "intellij.vcs.git"})
public final class MergeConflictResolveUtil {
    @NotNull
    public static final MergeConflictResolveUtil INSTANCE = new MergeConflictResolveUtil();
    @NotNull
    private static final Key<WindowWrapper> ACTIVE_MERGE_WINDOW;

    private MergeConflictResolveUtil() {
    }

    @RequiresEdt
    public final void showMergeWindow(@NotNull Project project, @Nullable VirtualFile file2, @NotNull BackgroundableActionLock lock, @NotNull Function0<GitMergeHandler.Resolver> resolverComputer) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter(resolverComputer, (String)"resolverComputer");
        if (this.focusActiveMergeWindow(file2)) {
            return;
        }
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        if (file2 != null) {
            string = new MergeDialogCustomizer().getMergeWindowTitle(file2);
        } else {
            String string2 = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"merge.files.dialog.title\")");
        }
        String title = string;
        Consumer windowHandler = arg_0 -> MergeConflictResolveUtil.showMergeWindow$lambda$1(project, file2, lock, arg_0);
        DiffDialogHints hints = new DiffDialogHints(WindowWrapper.Mode.FRAME, null, windowHandler);
        MyProducer producer = new MyProducer(project, title, resolverComputer);
        DiffManagerEx.getInstance().showMergeBuiltin(project, (MergeRequestProducer)producer, hints);
    }

    private final void putActiveWindowKey(Project project, WindowWrapper wrapper, VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        Window window = wrapper.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"wrapper.window");
        Window window2 = window;
        if (!(window2 instanceof JFrame)) {
            return;
        }
        file2.putUserData(ACTIVE_MERGE_WINDOW, (Object)wrapper);
        EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        UIUtil.runWhenWindowClosed((Window)window2, () -> MergeConflictResolveUtil.putActiveWindowKey$lambda$2(file2, project));
    }

    public final boolean hasActiveMergeWindow$intellij_vcs_git(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2.getUserData(ACTIVE_MERGE_WINDOW) != null;
    }

    private final boolean focusActiveMergeWindow(VirtualFile file2) {
        VirtualFile virtualFile = file2;
        if (virtualFile == null || (virtualFile = (WindowWrapper)virtualFile.getUserData(ACTIVE_MERGE_WINDOW)) == null) {
            return false;
        }
        VirtualFile wrapper = virtualFile;
        UIUtil.toFront((Window)wrapper.getWindow());
        return true;
    }

    private static final void showMergeWindow$lambda$1$lambda$0(BackgroundableActionLock $lock) {
        Intrinsics.checkNotNullParameter((Object)$lock, (String)"$lock");
        $lock.unlock();
    }

    private static final void showMergeWindow$lambda$1(Project $project, VirtualFile $file, BackgroundableActionLock $lock, WindowWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$lock, (String)"$lock");
        UIUtil.runWhenWindowClosed((Window)wrapper.getWindow(), () -> MergeConflictResolveUtil.showMergeWindow$lambda$1$lambda$0($lock));
        Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"wrapper");
        INSTANCE.putActiveWindowKey($project, wrapper, $file);
    }

    private static final void putActiveWindowKey$lambda$2(VirtualFile $file, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $file.putUserData(ACTIVE_MERGE_WINDOW, null);
        EditorNotifications.getInstance((Project)$project).updateNotifications($file);
    }

    static {
        Key key = Key.create((String)"ResolveConflictsWindow");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<WindowWrapper>(\"ResolveConflictsWindow\")");
        ACTIVE_MERGE_WINDOW = key;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyProducer;", "Lcom/intellij/diff/merge/MergeRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolverComputer", "()Lkotlin/jvm/functions/Function0;", "getTitle", "()Ljava/lang/String;", "getName", "process", "Lcom/intellij/diff/merge/MergeRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
    private static final class MyProducer
    implements MergeRequestProducer {
        @NotNull
        private final Project project;
        @NotNull
        private final String title;
        @NotNull
        private final Function0<GitMergeHandler.Resolver> resolverComputer;

        public MyProducer(@NotNull Project project, @NotNull String title, @NotNull Function0<GitMergeHandler.Resolver> resolverComputer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(resolverComputer, (String)"resolverComputer");
            this.project = project;
            this.title = title;
            this.resolverComputer = resolverComputer;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final Function0<GitMergeHandler.Resolver> getResolverComputer() {
            return this.resolverComputer;
        }

        @NotNull
        public String getName() {
            return this.title;
        }

        @NotNull
        public MergeRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                GitMergeHandler.Resolver resolver = (GitMergeHandler.Resolver)this.resolverComputer.invoke();
                MergeData mergeData = resolver.getMergeData();
                Intrinsics.checkNotNullExpressionValue((Object)mergeData, (String)"resolver.mergeData");
                MergeData mergeData2 = mergeData;
                byte[][] byArrayArray = new byte[][]{mergeData2.CURRENT, mergeData2.ORIGINAL, mergeData2.LAST};
                List byteContents = CollectionsKt.listOf((Object[])((Object[])byArrayArray));
                MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(this.project, resolver.getVirtualFile(), byteContents, resolver.getWindowTitle(), resolver.getContentTitles());
                Intrinsics.checkNotNullExpressionValue((Object)mergeRequest, (String)"getInstance().createMerg\u2026, resolver.contentTitles)");
                MergeRequest request = mergeRequest;
                MergeDialogCustomizer.DiffEditorTitleCustomizerList $this$process_u24lambda_u240 = resolver.getTitleCustomizerList();
                boolean bl = false;
                Object[] objectArray = new DiffEditorTitleCustomizer[]{$this$process_u24lambda_u240.getLeftTitleCustomizer(), $this$process_u24lambda_u240.getCenterTitleCustomizer(), $this$process_u24lambda_u240.getRightTitleCustomizer()};
                request.putUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, (Object)CollectionsKt.listOf((Object[])objectArray));
                MergeUtils.putRevisionInfos((MergeRequest)request, (MergeData)mergeData2);
                MergeCallback.register((MergeRequest)request, (MergeCallback)new MyMergeCallback(resolver));
                return request;
            }
            catch (Throwable e) {
                throw new DiffRequestProducerException(e);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyMergeCallback;", "Lcom/intellij/diff/merge/MergeCallback;", "resolver", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "(Lgit4idea/conflicts/GitMergeHandler$Resolver;)V", "addListener", "", "listener", "Lcom/intellij/diff/merge/MergeCallback$Listener;", "disposable", "Lcom/intellij/openapi/Disposable;", "applyResult", "result", "Lcom/intellij/diff/merge/MergeResult;", "checkIsValid", "", "intellij.vcs.git"})
    private static final class MyMergeCallback
    extends MergeCallback {
        @NotNull
        private final GitMergeHandler.Resolver resolver;

        public MyMergeCallback(@NotNull GitMergeHandler.Resolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            this.resolver = resolver;
        }

        /*
         * WARNING - void declaration
         */
        public void applyResult(@NotNull MergeResult result2) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Project project = this.resolver.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"resolver.project");
            Project project2 = project;
            VirtualFile virtualFile = this.resolver.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"resolver.virtualFile");
            VirtualFile file2 = virtualFile;
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            MergeUtil.reportProjectFileChangeIfNeeded((Project)project2, (VirtualFile)file2);
            if (result2 != MergeResult.CANCEL) {
                void title$iv;
                String string = GitBundle.message("progress.finishing.conflict.resolve", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"progress.finishing.conflict.resolve\")");
                String string2 = string;
                boolean cancellable$iv = false;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, this, result2){
                    final /* synthetic */ MyMergeCallback this$0;
                    final /* synthetic */ MergeResult $result$inlined;
                    {
                        this.this$0 = myMergeCallback;
                        this.$result$inlined = mergeResult;
                        super($project, $title, $cancellable);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        MyMergeCallback.access$getResolver$p(this.this$0).onConflictResolved(this.$result$inlined);
                    }
                });
            }
        }

        public boolean checkIsValid() {
            return this.resolver.checkIsValid();
        }

        public void addListener(@NotNull MergeCallback.Listener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.resolver.addListener(listener2, disposable);
        }

        public static final /* synthetic */ GitMergeHandler.Resolver access$getResolver$p(MyMergeCallback $this) {
            return $this.resolver;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u00020\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$NotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "intellij.vcs.git"})
    public static final class NotificationProvider
    extends EditorNotifications.Provider<EditorNotificationPanel> {
        @NotNull
        private final Key<EditorNotificationPanel> KEY;

        public NotificationProvider() {
            Key key = Key.create((String)"MergeConflictResolveUtil.NotificationProvider");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<EditorNotificatio\u2026il.NotificationProvider\")");
            this.KEY = key;
        }

        @NotNull
        public Key<EditorNotificationPanel> getKey() {
            return this.KEY;
        }

        @Nullable
        public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WindowWrapper windowWrapper = (WindowWrapper)file2.getUserData(ACTIVE_MERGE_WINDOW);
            if (windowWrapper == null) {
                return null;
            }
            WindowWrapper wrapper = windowWrapper;
            EditorNotificationPanel panel2 = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN, EditorNotificationPanel.Status.Info);
            panel2.setText(GitBundle.message("link.label.editor.notification.merge.conflicts.resolve.in.progress", new Object[0]));
            panel2.createActionLabel(GitBundle.message("link.label.merge.conflicts.resolve.in.progress.focus.window", new Object[0]), () -> NotificationProvider.createNotificationPanel$lambda$0(wrapper));
            panel2.createActionLabel(GitBundle.message("link.label.merge.conflicts.resolve.in.progress.cancel.resolve", new Object[0]), () -> NotificationProvider.createNotificationPanel$lambda$1(wrapper));
            return panel2;
        }

        private static final void createNotificationPanel$lambda$0(WindowWrapper $wrapper) {
            Intrinsics.checkNotNullParameter((Object)$wrapper, (String)"$wrapper");
            UIUtil.toFront((Window)$wrapper.getWindow());
        }

        private static final void createNotificationPanel$lambda$1(WindowWrapper $wrapper) {
            Intrinsics.checkNotNullParameter((Object)$wrapper, (String)"$wrapper");
            $wrapper.close();
        }
    }
}

