/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MergeConflictResolveUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJV\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\r0\u0010H\u0000\u00a2\u0006\u0002\b\u000eJ%\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0017J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J+\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b!JN\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\r0\u0010H\u0000\u00a2\u0006\u0002\b!\u00a8\u0006\""}, d2={"Lgit4idea/conflicts/GitConflictsUtil;", "", "()V", "acceptConflictSide", "", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lgit4idea/conflicts/GitMergeHandler;", "selectedConflicts", "", "Lgit4idea/repo/GitConflict;", "takeTheirs", "", "acceptConflictSide$intellij_vcs_git", "isReversed", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/ParameterName;", "name", "root", "canShowMergeWindow", "conflict", "canShowMergeWindow$intellij_vcs_git", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "getConflictOperationLock$intellij_vcs_git", "getConflictType", "", "getConflictType$intellij_vcs_git", "hasActiveMergeWindow", "isReversedRoot", "showMergeWindow", "showMergeWindow$intellij_vcs_git", "intellij.vcs.git"})
public final class GitConflictsUtil {
    @NotNull
    public static final GitConflictsUtil INSTANCE = new GitConflictsUtil();

    private GitConflictsUtil() {
    }

    @NotNull
    public final BackgroundableActionLock getConflictOperationLock$intellij_vcs_git(@NotNull Project project, @NotNull GitConflict conflict2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)conflict2, (String)"conflict");
        Object[] objectArray = new Object[]{conflict2.getFilePath()};
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock((Project)project, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)backgroundableActionLock, (String)"getLock(project, conflict.filePath)");
        return backgroundableActionLock;
    }

    public final void acceptConflictSide$intellij_vcs_git(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts, boolean takeTheirs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        this.acceptConflictSide$intellij_vcs_git(project, handler, selectedConflicts, takeTheirs, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return GitConflictsUtil.access$isReversedRoot(GitConflictsUtil.INSTANCE, this.$project, root);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void acceptConflictSide$intellij_vcs_git(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts, boolean takeTheirs, @NotNull Function1<? super VirtualFile, Boolean> isReversed) {
        void $this$mapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        Intrinsics.checkNotNullParameter(isReversed, (String)"isReversed");
        Iterable $this$filterNot$iv = selectedConflicts;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            GitConflict it = (GitConflict)element$iv$iv;
            boolean bl = false;
            if (INSTANCE.getConflictOperationLock$intellij_vcs_git(project, it).isLocked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (conflicts.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = conflicts;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitConflict bl = (GitConflict)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(INSTANCE.getConflictOperationLock$intellij_vcs_git(project, (GitConflict)it));
        }
        List locks = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = locks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
            boolean bl = false;
            it.lock();
        }
        Object[] objectArray = new Object[]{conflicts.size()};
        String string = GitBundle.message("conflicts.accept.progress", objectArray);
        new Task.Backgroundable(project, conflicts, isReversed, handler, takeTheirs, locks, string){
            final /* synthetic */ List<GitConflict> $conflicts;
            final /* synthetic */ Function1<VirtualFile, Boolean> $isReversed;
            final /* synthetic */ GitMergeHandler $handler;
            final /* synthetic */ boolean $takeTheirs;
            final /* synthetic */ List<BackgroundableActionLock> $locks;
            {
                this.$conflicts = $conflicts;
                this.$isReversed = $isReversed;
                this.$handler = $handler;
                this.$takeTheirs = $takeTheirs;
                this.$locks = $locks;
                super($project, $super_call_param$1, true);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void destination$iv;
                Iterable $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable iterable = this.$conflicts;
                Collection collection = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    GitConflict gitConflict = (GitConflict)item$iv;
                    void var11_11 = destination$iv;
                    boolean bl = false;
                    var11_11.add(it.getRoot());
                }
                $this$mapTo$iv = (Iterable)destination$iv;
                Function1<VirtualFile, Boolean> predicate$iv = this.$isReversed;
                boolean $i$f$filter = false;
                Iterator<T> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List reversedRoots = (List)destination$iv$iv;
                this.$handler.acceptOneVersion((Collection<? extends GitConflict>)this.$conflicts, reversedRoots, this.$takeTheirs);
            }

            public void onFinished() {
                Iterable $this$forEach$iv = this.$locks;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BackgroundableActionLock it = (BackgroundableActionLock)element$iv;
                    boolean bl = false;
                    it.unlock();
                }
            }
        }.queue();
    }

    private final boolean hasActiveMergeWindow(GitConflict conflict2) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(conflict2.getFilePath().getPath());
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file2 = virtualFile;
        return MergeConflictResolveUtil.INSTANCE.hasActiveMergeWindow$intellij_vcs_git(file2);
    }

    public final boolean canShowMergeWindow$intellij_vcs_git(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull GitConflict conflict2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)conflict2, (String)"conflict");
        return handler.canResolveConflict(conflict2) && (!this.getConflictOperationLock$intellij_vcs_git(project, conflict2).isLocked() || this.hasActiveMergeWindow(conflict2));
    }

    public final void showMergeWindow$intellij_vcs_git(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        this.showMergeWindow$intellij_vcs_git(project, handler, selectedConflicts, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return GitConflictsUtil.access$isReversedRoot(GitConflictsUtil.INSTANCE, this.$project, root);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void showMergeWindow$intellij_vcs_git(@NotNull Project project, @NotNull GitMergeHandler handler, @NotNull List<? extends GitConflict> selectedConflicts, @NotNull Function1<? super VirtualFile, Boolean> isReversed) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(selectedConflicts, (String)"selectedConflicts");
        Intrinsics.checkNotNullParameter(isReversed, (String)"isReversed");
        Iterable $this$filter$iv = selectedConflicts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitConflict it = (GitConflict)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.canShowMergeWindow$intellij_vcs_git(project, handler, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (conflicts.isEmpty()) {
            return;
        }
        for (GitConflict conflict2 : conflicts) {
            VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(conflict2.getFilePath().getPath());
            if (file2 == null) {
                destination$iv$iv = new Object[]{conflict2.getFilePath()};
                VcsNotifier.getInstance((Project)project).notifyError("git.cannot.resolve.conflict", GitBundle.message("conflicts.merge.window.error.title", new Object[0]), GitBundle.message("conflicts.merge.window.error.message", destination$iv$iv));
                continue;
            }
            BackgroundableActionLock lock = this.getConflictOperationLock$intellij_vcs_git(project, conflict2);
            MergeConflictResolveUtil.INSTANCE.showMergeWindow(project, file2, lock, (Function0<GitMergeHandler.Resolver>)((Function0)new Function0<GitMergeHandler.Resolver>(handler, conflict2, file2, isReversed){
                final /* synthetic */ GitMergeHandler $handler;
                final /* synthetic */ GitConflict $conflict;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Function1<VirtualFile, Boolean> $isReversed;
                {
                    this.$handler = $handler;
                    this.$conflict = $conflict;
                    this.$file = $file;
                    this.$isReversed = $isReversed;
                    super(0);
                }

                @NotNull
                public final GitMergeHandler.Resolver invoke() {
                    VirtualFile virtualFile = this.$conflict.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"conflict.root");
                    GitMergeHandler.Resolver resolver = this.$handler.resolveConflict(this.$conflict, this.$file, (Boolean)this.$isReversed.invoke((Object)virtualFile));
                    Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"handler.resolveConflict(\u2026sReversed(conflict.root))");
                    return resolver;
                }
            }));
        }
    }

    @Nls
    @NotNull
    public final String getConflictType$intellij_vcs_git(@NotNull GitConflict conflict2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)conflict2, (String)"conflict");
        GitConflict.Status status = conflict2.getStatus(GitConflict.ConflictSide.OURS, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)status), (String)"conflict.getStatus(GitCo\u2026.ConflictSide.OURS, true)");
        GitConflict.Status oursStatus = status;
        GitConflict.Status status2 = conflict2.getStatus(GitConflict.ConflictSide.THEIRS, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)status2), (String)"conflict.getStatus(GitCo\u2026onflictSide.THEIRS, true)");
        GitConflict.Status theirsStatus = status2;
        if (oursStatus == GitConflict.Status.DELETED && theirsStatus == GitConflict.Status.DELETED) {
            String string2 = GitBundle.message("conflicts.type.both.deleted", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"conflicts.type.both.deleted\")");
        } else if (oursStatus == GitConflict.Status.ADDED && theirsStatus == GitConflict.Status.ADDED) {
            String string3 = GitBundle.message("conflicts.type.both.added", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"conflicts.type.both.added\")");
        } else if (oursStatus == GitConflict.Status.MODIFIED && theirsStatus == GitConflict.Status.MODIFIED) {
            String string4 = GitBundle.message("conflicts.type.both.modified", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"conflicts.type.both.modified\")");
        } else if (oursStatus == GitConflict.Status.DELETED) {
            String string5 = GitBundle.message("conflicts.type.deleted.by.you", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"conflicts.type.deleted.by.you\")");
        } else if (theirsStatus == GitConflict.Status.DELETED) {
            String string6 = GitBundle.message("conflicts.type.deleted.by.them", new Object[0]);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"conflicts.type.deleted.by.them\")");
        } else if (oursStatus == GitConflict.Status.ADDED) {
            String string7 = GitBundle.message("conflicts.type.added.by.you", new Object[0]);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(\"conflicts.type.added.by.you\")");
        } else if (theirsStatus == GitConflict.Status.ADDED) {
            String string8 = GitBundle.message("conflicts.type.added.by.them", new Object[0]);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(\"conflicts.type.added.by.them\")");
        } else {
            throw new IllegalStateException("ours: " + oursStatus + "; theirs: " + theirsStatus);
        }
        return string;
    }

    private final boolean isReversedRoot(Project project, VirtualFile root) {
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return false;
        }
        GitRepository repository = gitRepository;
        return GitMergeUtil.isReverseRoot(repository);
    }

    public static final /* synthetic */ boolean access$isReversedRoot(GitConflictsUtil $this, Project project, VirtualFile root) {
        return $this.isReversedRoot(project, root);
    }
}

