/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config.gpg;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.GitImpl;
import git4idea.config.GitConfigUtil;
import git4idea.config.gpg.GpgKey;
import git4idea.config.gpg.RepoConfig;
import git4idea.config.gpg.SecretKeys;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u0018\b\u0002\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u000f0\u00132\b\u0012\u0004\u0012\u00020\u000f0\u0013\u00a8\u0006\u0014"}, d2={"checkKeyCapabilities", "", "capabilities", "", "parseSecretKeys", "Lgit4idea/config/gpg/SecretKeys;", "output", "readAvailableSecretKeys", "project", "Lcom/intellij/openapi/project/Project;", "readGitGpgConfig", "Lgit4idea/config/gpg/RepoConfig;", "repository", "Lgit4idea/repo/GitRepository;", "writeGitGpgConfig", "", "gpgKey", "Lgit4idea/config/gpg/GpgKey;", "ValueListener", "Lkotlin/Function0;", "intellij.vcs.git"})
public final class GitGpgConfigUtilsKt {
    private static final RepoConfig readGitGpgConfig(GitRepository repository) throws VcsException {
        Boolean isEnabled = GitConfigUtil.getBooleanValue(GitConfigUtil.getValue(repository.getProject(), repository.getRoot(), "commit.gpgSign"));
        if (!Intrinsics.areEqual((Object)isEnabled, (Object)true)) {
            return new RepoConfig(null);
        }
        String keyValue = GitConfigUtil.getValue(repository.getProject(), repository.getRoot(), "user.signingkey");
        if (keyValue == null) {
            return new RepoConfig(null);
        }
        return new RepoConfig(new GpgKey(((Object)StringsKt.trim((CharSequence)keyValue)).toString()));
    }

    private static final SecretKeys readAvailableSecretKeys(Project project) throws VcsException {
        List<GitRepository> list2 = GitRepositoryManager.getInstance(project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance(project).repositories");
        GitRepository repository = (GitRepository)CollectionsKt.firstOrNull(list2);
        if (repository == null) {
            return new SecretKeys(CollectionsKt.emptyList(), MapsKt.emptyMap());
        }
        String string = GitConfigUtil.getValue(project, repository.getRoot(), "gpg.program");
        if (string == null) {
            string = "gpg";
        }
        String gpgCommand = string;
        String[] stringArray = new String[]{gpgCommand, "--list-secret-keys", "--with-colons", "--fixed-list-mode", "--batch", "--no-tty"};
        String string2 = GitImpl.runBundledCommand(project, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"runBundledCommand(projec\u2026\", \"--batch\", \"--no-tty\")");
        String output = string2;
        return GitGpgConfigUtilsKt.parseSecretKeys(output);
    }

    private static final SecretKeys parseSecretKeys(String output) {
        List result2 = new ArrayList();
        Map descriptions = new LinkedHashMap();
        GpgKey lastKey = null;
        StringScanner scanner = new StringScanner(output);
        while (scanner.hasMoreData()) {
            String line = scanner.line();
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            char[] cArray = new char[]{':'};
            List fields = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String type = (String)CollectionsKt.getOrNull((List)fields, (int)0);
            if (Intrinsics.areEqual((Object)type, (Object)"sec")) {
                String keyId = (String)CollectionsKt.getOrNull((List)fields, (int)4);
                String capabilities = (String)CollectionsKt.getOrNull((List)fields, (int)11);
                if (keyId != null && capabilities != null && GitGpgConfigUtilsKt.checkKeyCapabilities(capabilities)) {
                    GpgKey gpgKey = new GpgKey(keyId);
                    result2.add(gpgKey);
                    lastKey = gpgKey;
                } else {
                    lastKey = null;
                }
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"uid")) continue;
            String userId = (String)CollectionsKt.getOrNull((List)fields, (int)9);
            if (userId != null && lastKey != null) {
                String string;
                Map map2 = descriptions;
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.unescapeAnsiStringCharacters((String)userId), (String)"unescapeAnsiStringCharacters(userId)");
                map2.put(lastKey, string);
            }
            lastKey = null;
        }
        return new SecretKeys(result2, descriptions);
    }

    private static final boolean checkKeyCapabilities(String capabilities) {
        if (StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"D", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"s", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"S", (boolean)false, (int)2, null);
    }

    public static final void writeGitGpgConfig(@NotNull GitRepository repository, @Nullable GpgKey gpgKey) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        if (gpgKey != null) {
            GitConfigUtil.setValue(repository.getProject(), repository.getRoot(), "commit.gpgSign", "true", new String[0]);
            GitConfigUtil.setValue(repository.getProject(), repository.getRoot(), "user.signingkey", gpgKey.getId(), new String[0]);
        } else {
            GitConfigUtil.setValue(repository.getProject(), repository.getRoot(), "commit.gpgSign", "false", new String[0]);
        }
    }

    public static final /* synthetic */ RepoConfig access$readGitGpgConfig(GitRepository repository) {
        return GitGpgConfigUtilsKt.readGitGpgConfig(repository);
    }

    public static final /* synthetic */ SecretKeys access$readAvailableSecretKeys(Project project) {
        return GitGpgConfigUtilsKt.readAvailableSecretKeys(project);
    }
}

