/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepository;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GitVersionSpecialty {
    ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 1, 1));
        }
    }
    ,
    CAN_USE_SHELL_HELPER_SCRIPT_ON_WINDOWS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.getType().equals((Object)GitVersion.Type.MSYS) && version.isLaterOrEqual(new GitVersion(2, 3, 0, 0));
        }
    }
    ,
    STARTED_USING_RAW_BODY_IN_FORMAT{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 2, 0));
        }
    }
    ,
    SUPPORTS_FETCH_PRUNE{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 7, 2));
        }
    }
    ,
    OLD_STYLE_OF_UNTRACKED_AND_LOCAL_CHANGES_WOULD_BE_OVERWRITTEN{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isOlderOrEqual(new GitVersion(1, 7, 3, 0));
        }
    }
    ,
    KNOWS_PULL_REBASE{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 9, 0));
        }
    }
    ,
    KNOWS_REBASE_DROP_ACTION{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 6, 0, 0));
        }
    }
    ,
    CLONE_RECURSE_SUBMODULES{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 11, 0));
        }
    }
    ,
    NO_WALK_UNSORTED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 12, 1));
        }
    }
    ,
    CAN_AMEND_WITHOUT_FILES{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 11, 3));
        }
    }
    ,
    SUPPORTS_FOLLOW_TAGS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 8, 3, 0));
        }
    }
    ,
    CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 2, 0));
        }
    }
    ,
    CAN_OVERRIDE_CREDENTIAL_HELPER_WITH_EMPTY{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 9, 0, 0));
        }
    }
    ,
    CAN_USE_SCHANNEL{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 14, 0, 0)) && version.getType().equals((Object)GitVersion.Type.MSYS);
        }
    }
    ,
    FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 9, 0, 0));
        }
    }
    ,
    LOG_AUTHOR_FILTER_SUPPORTS_VERTICAL_BAR{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return !SystemInfo.isMac || version.isLaterOrEqual(new GitVersion(1, 8, 3, 3));
        }
    }
    ,
    KNOWS_SET_UPSTREAM_TO{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 8, 0, 0));
        }
    }
    ,
    KNOWS_CORE_COMMENT_CHAR{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 8, 2, 0));
        }
    }
    ,
    PRE_PUSH_HOOK{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 8, 2, 0));
        }
    }
    ,
    SUPPORTS_FORCE_PUSH_WITH_LEASE{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 9, 4, 0));
        }
    }
    ,
    INCOMING_OUTGOING_BRANCH_INFO{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 9, 0, 0));
        }
    }
    ,
    LF_SEPARATORS_IN_STDIN{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return SystemInfo.isWindows && !version.isLaterOrEqual(new GitVersion(2, 8, 0, 0));
        }
    }
    ,
    ENV_GIT_TRACE_PACK_ACCESS_ALLOWED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 1, 0, 0));
        }
    }
    ,
    ENV_GIT_OPTIONAL_LOCKS_ALLOWED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 15, 0, 0));
        }
    }
    ,
    CACHEINFO_SUPPORTS_SINGLE_PARAMETER_FORM{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 0, 0, 0));
        }
    }
    ,
    CAT_FILE_SUPPORTS_FILTERS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 11, 0, 0));
        }
    }
    ,
    CAT_FILE_SUPPORTS_TEXTCONV{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 2, 0, 0));
        }
    }
    ,
    REBASE_MERGES_REPLACES_PRESERVE_MERGES{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 22, 0, 0));
        }
    }
    ,
    STATUS_SUPPORTS_IGNORED_MODES{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 16, 0, 0));
        }
    }
    ,
    STATUS_SUPPORTS_NO_RENAMES{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 18, 0, 0));
        }
    }
    ,
    RESTORE_SUPPORTED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return Registry.is((String)"git.can.use.restore.command") && version.isLaterOrEqual(new GitVersion(2, 25, 1, 0));
        }
    }
    ,
    NO_VERIFY_SUPPORTED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 24, 0, 0));
        }
    }
    ,
    DIFF_MERGES_M_USES_DEFAULT_SETTING{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 32, 0, 0));
        }
    }
    ,
    DIFF_MERGES_SUPPORTS_FIRST_PARENT{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 31, 0, 0));
        }
    }
    ,
    ADD_REJECTS_SPARSE_FILES_FOR_CONFLICTS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(2, 34, 0, 0));
        }
    };


    public abstract boolean existsIn(@NotNull GitVersion var1);

    public boolean existsIn(@NotNull Project project) {
        GitVersion version = GitExecutableManager.getInstance().tryGetVersion(project);
        return this.existsIn(Objects.requireNonNullElse(version, GitVersion.NULL));
    }

    public boolean existsIn(@Nullable Project project, @NotNull GitExecutable executable) {
        GitVersion version = GitExecutableManager.getInstance().tryGetVersion(project, executable);
        return this.existsIn(Objects.requireNonNullElse(version, GitVersion.NULL));
    }

    public boolean existsIn(@NotNull GitRepository repository) {
        return this.existsIn(repository.getProject());
    }

    public boolean existsIn(@NotNull AbstractVcs vcs) {
        return this.existsIn(vcs.getProject());
    }
}

