/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.vcs.log.VcsUser;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsOptions;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.reset.GitResetMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class GitVcsSettings
extends SimplePersistentStateComponent<GitVcsOptions>
implements DvcsSyncSettings,
DvcsCompareSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;

    public GitVcsSettings() {
        super((BaseState)new GitVcsOptions());
    }

    public GitVcsApplicationSettings getAppSettings() {
        return GitVcsApplicationSettings.getInstance();
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)((Object)project.getService(GitVcsSettings.class));
    }

    @NotNull
    public UpdateMethod getUpdateMethod() {
        return ((GitVcsOptions)this.getState()).getUpdateMethod();
    }

    public void setUpdateMethod(UpdateMethod updateType) {
        ((GitVcsOptions)this.getState()).setUpdateMethod(updateType);
    }

    @NotNull
    public GitSaveChangesPolicy getSaveChangesPolicy() {
        return ((GitVcsOptions)this.getState()).getSaveChangesPolicy();
    }

    public void setSaveChangesPolicy(GitSaveChangesPolicy value) {
        ((GitVcsOptions)this.getState()).setSaveChangesPolicy(value);
    }

    public void saveCommitAuthor(@NotNull VcsUser author) {
        List<String> previousCommitAuthors = ((GitVcsOptions)this.getState()).getPreviousCommitAuthors();
        previousCommitAuthors.remove(author.toString());
        while (previousCommitAuthors.size() >= 16) {
            previousCommitAuthors.remove(previousCommitAuthors.size() - 1);
        }
        previousCommitAuthors.add(0, author.toString());
    }

    public String[] getCommitAuthors() {
        return ArrayUtilRt.toStringArray(((GitVcsOptions)this.getState()).getPreviousCommitAuthors());
    }

    public void loadState(@NotNull GitVcsOptions state) {
        super.loadState((BaseState)state);
        GitVcsSettings.migrateUpdateIncomingBranchInfo(state);
    }

    private static void migrateUpdateIncomingBranchInfo(@NotNull GitVcsOptions state) {
        if (!state.isUpdateBranchesInfo()) {
            state.setIncomingCheckStrategy(GitIncomingCheckStrategy.Never);
            state.setUpdateBranchesInfo(true);
        }
    }

    @Nullable
    public String getPathToGit() {
        return ((GitVcsOptions)this.getState()).getPathToGit();
    }

    public void setPathToGit(@Nullable String value) {
        ((GitVcsOptions)this.getState()).setPathToGit(value);
        ((GitExecutableListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GitExecutableManager.TOPIC)).executableChanged();
    }

    public boolean autoUpdateIfPushRejected() {
        return ((GitVcsOptions)this.getState()).isPushAutoUpdate();
    }

    public void setAutoUpdateIfPushRejected(boolean value) {
        ((GitVcsOptions)this.getState()).setPushAutoUpdate(value);
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        return ((GitVcsOptions)this.getState()).getRootSync();
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value value) {
        ((GitVcsOptions)this.getState()).setRootSync(value);
    }

    @Nullable
    public String getRecentRootPath() {
        return ((GitVcsOptions)this.getState()).getRecentGitRootPath();
    }

    public void setRecentRoot(@NotNull String value) {
        ((GitVcsOptions)this.getState()).setRecentGitRootPath(value);
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        return ((GitVcsOptions)this.getState()).getRecentBranchByRepository();
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        ((GitVcsOptions)this.getState()).getRecentBranchByRepository().put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return ((GitVcsOptions)this.getState()).getRecentCommonBranch();
    }

    public void setRecentCommonBranch(@NotNull String value) {
        ((GitVcsOptions)this.getState()).setRecentCommonBranch(value);
    }

    public boolean warnAboutCrlf() {
        return ((GitVcsOptions)this.getState()).getWarnAboutCrlf();
    }

    public void setWarnAboutCrlf(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutCrlf(value);
    }

    public boolean warnAboutDetachedHead() {
        return ((GitVcsOptions)this.getState()).isWarnAboutDetachedHead();
    }

    public void setWarnAboutDetachedHead(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutDetachedHead(value);
    }

    @Nullable
    public GitResetMode getResetMode() {
        return ((GitVcsOptions)this.getState()).getResetMode();
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        ((GitVcsOptions)this.getState()).setResetMode(mode);
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return ((GitVcsOptions)this.getState()).getPushTags();
    }

    public void setPushTagMode(@Nullable GitPushTagMode value) {
        ((GitVcsOptions)this.getState()).setPushTags(value);
    }

    public boolean shouldSignOffCommit() {
        return ((GitVcsOptions)this.getState()).isSignOffCommit();
    }

    public void setSignOffCommit(boolean value) {
        ((GitVcsOptions)this.getState()).setSignOffCommit(value);
    }

    @NotNull
    public GitIncomingCheckStrategy getIncomingCheckStrategy() {
        return ((GitVcsOptions)this.getState()).getIncomingCheckStrategy();
    }

    public void setIncomingCheckStrategy(@NotNull GitIncomingCheckStrategy strategy) {
        ((GitVcsOptions)this.getState()).setIncomingCheckStrategy(strategy);
    }

    public boolean shouldPreviewPushOnCommitAndPush() {
        return ((GitVcsOptions)this.getState()).isPreviewPushOnCommitAndPush();
    }

    public void setPreviewPushOnCommitAndPush(boolean value) {
        ((GitVcsOptions)this.getState()).setPreviewPushOnCommitAndPush(value);
    }

    public boolean isPreviewPushProtectedOnly() {
        return ((GitVcsOptions)this.getState()).isPreviewPushProtectedOnly();
    }

    public void setPreviewPushProtectedOnly(boolean value) {
        ((GitVcsOptions)this.getState()).setPreviewPushProtectedOnly(value);
    }

    public boolean isCommitRenamesSeparately() {
        return ((GitVcsOptions)this.getState()).isCommitRenamesSeparately();
    }

    public void setCommitRenamesSeparately(boolean value) {
        ((GitVcsOptions)this.getState()).setCommitRenamesSeparately(value);
    }

    @NotNull
    public DvcsBranchSettings getBranchSettings() {
        return ((GitVcsOptions)this.getState()).getBranchSettings();
    }

    public boolean shouldSetUserNameGlobally() {
        return ((GitVcsOptions)this.getState()).isSetUserNameGlobally();
    }

    public void setUserNameGlobally(boolean value) {
        ((GitVcsOptions)this.getState()).setSetUserNameGlobally(value);
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return ((GitVcsOptions)this.getState()).isSwapSidesInCompareBranches();
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        ((GitVcsOptions)this.getState()).setSwapSidesInCompareBranches(value);
    }

    public boolean shouldAddSuffixToCherryPicksOfPublishedCommits() {
        return ((GitVcsOptions)this.getState()).isAddSuffixToCherryPicksOfPublishedCommits();
    }

    public void setAddSuffixToCherryPicks(boolean value) {
        ((GitVcsOptions)this.getState()).setAddSuffixToCherryPicksOfPublishedCommits(value);
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }
    }
}

