/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectPostStartupActivity;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsOptions;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lgit4idea/config/GitSetupProjectConfig;", "Lcom/intellij/openapi/startup/ProjectPostStartupActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupConfigIfNeeded", "ConfigVariables", "intellij.vcs.git"})
public final class GitSetupProjectConfig
implements ProjectPostStartupActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        ProjectLevelVcsManager.getInstance((Project)project).runAfterInitialization(() -> GitSetupProjectConfig.execute$lambda$0(this, project));
        return Unit.INSTANCE;
    }

    private final void setupConfigIfNeeded(Project project) {
        GitVcsOptions settings = (GitVcsOptions)GitVcsSettings.getInstance(project).getState();
        for (ConfigVariables configVar : ConfigVariables.values()) {
            Function1<GitVcsOptions, String> function1 = configVar.getSettingsGetter();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)settings), (String)"settings");
            String settingsValue = (String)function1.invoke((Object)settings);
            if (settingsValue == null) continue;
            List rootsToUpdate = new ArrayList();
            for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
                String value = GitConfigUtil.getValue(project, repo.getRoot(), configVar.getGitName());
                if (value != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)repo, (String)"repo");
                rootsToUpdate.add(repo);
            }
            for (GitRepository repo : rootsToUpdate) {
                String[] stringArray = new String[]{"--local"};
                GitConfigUtil.setValue(project, repo.getRoot(), configVar.getGitName(), settingsValue, stringArray);
            }
        }
    }

    private static final void execute$lambda$0(GitSetupProjectConfig this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.setupConfigIfNeeded($project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lgit4idea/config/GitSetupProjectConfig$ConfigVariables;", "", "gitName", "", "settingsGetter", "Lkotlin/Function1;", "Lgit4idea/config/GitVcsOptions;", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getGitName", "()Ljava/lang/String;", "getSettingsGetter", "()Lkotlin/jvm/functions/Function1;", "GC_AUTO", "CORE_LONGPATHS", "intellij.vcs.git"})
    private static final class ConfigVariables
    extends Enum<ConfigVariables> {
        @NotNull
        private final String gitName;
        @NotNull
        private final Function1<GitVcsOptions, String> settingsGetter;
        public static final /* enum */ ConfigVariables GC_AUTO = new ConfigVariables("gc.auto", (Function1<? super GitVcsOptions, String>)((Function1)1.INSTANCE));
        public static final /* enum */ ConfigVariables CORE_LONGPATHS = new ConfigVariables("core.longpaths", (Function1<? super GitVcsOptions, String>)((Function1)2.INSTANCE));
        private static final /* synthetic */ ConfigVariables[] $VALUES;

        private ConfigVariables(String gitName, Function1<? super GitVcsOptions, String> settingsGetter) {
            this.gitName = gitName;
            this.settingsGetter = settingsGetter;
        }

        @NotNull
        public final String getGitName() {
            return this.gitName;
        }

        @NotNull
        public final Function1<GitVcsOptions, String> getSettingsGetter() {
            return this.settingsGetter;
        }

        public static ConfigVariables[] values() {
            return (ConfigVariables[])$VALUES.clone();
        }

        public static ConfigVariables valueOf(String value) {
            return Enum.valueOf(ConfigVariables.class, value);
        }

        static {
            $VALUES = configVariablesArray = new ConfigVariables[]{ConfigVariables.GC_AUTO, ConfigVariables.CORE_LONGPATHS};
        }
    }
}

