/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ModalityUiUtil;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        return (GitExecutableProblemsNotifier)project.getService(GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project) {
        this.myProject = project;
    }

    public void notifyExecutionError(@NotNull Throwable exception) {
        GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(this.myProject);
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(this.myProject);
        problemHandler.showError(exception, errorNotifier);
    }

    static void notify(@NotNull Project project, @NotNull BadGitExecutableNotification notification2) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (GitExecutableProblemsNotifier.ensureSingularOfType(project, ((Object)((Object)notification2)).getClass())) {
                notification2.notify(project);
            }
        });
    }

    private static boolean ensureSingularOfType(@NotNull Project project, @NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications = (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, project);
        int notificationsCount = currentNotifications.length;
        if (notificationsCount <= 0) {
            return true;
        }
        for (int i = 0; i < notificationsCount - 1; ++i) {
            currentNotifications[i].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification2 : (BadGitExecutableNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification2.expire();
        }
    }

    @Nls
    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? GitBundle.message("git.executable.error.file.not.found", cause.getMessage()) : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            return VcsBundle.message((String)"exception.text.unknown.error", (Object[])new Object[0]);
        }
        return errorMessage;
    }

    static class BadGitExecutableNotification
    extends Notification {
        BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
            super(groupDisplayId, Objects.requireNonNullElse(title, ""), content, type);
            this.setDisplayId("git.bad.executable");
        }
    }
}

