/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableContext;
import git4idea.config.GitExecutableDetector;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 !2\u00020\u0001:\u0004!\"#$B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH&J+\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0018\"\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H&R\u0017\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u0082\u0001\u0003%&'\u00a8\u0006("}, d2={"Lgit4idea/config/GitExecutable;", "", "()V", "exePath", "", "Lorg/jetbrains/annotations/NonNls;", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "createBundledCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "executableContext", "Lgit4idea/config/GitExecutableContext;", "Companion", "Local", "Unknown", "Wsl", "Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable$Unknown;", "Lgit4idea/config/GitExecutable$Wsl;", "intellij.vcs.git"})
public abstract class GitExecutable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";

    private GitExecutable() {
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getExePath();

    public abstract boolean isLocal();

    @NotNull
    public abstract String convertFilePath(@NotNull File var1);

    @NotNull
    public abstract File convertFilePathBack(@NotNull String var1, @NotNull File var2);

    public abstract void patchCommandLine(@NotNull GitHandler var1, @NotNull GeneralCommandLine var2, @NotNull GitExecutableContext var3) throws ExecutionException;

    @NotNull
    public abstract GeneralCommandLine createBundledCommandLine(@Nullable Project var1, String ... var2) throws ExecutionException;

    public /* synthetic */ GitExecutable(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/config/GitExecutable$Companion;", "", "()V", "CYGDRIVE_PREFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J+\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001c\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006*"}, d2={"Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable;", "exePath", "", "(Ljava/lang/String;)V", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "buildShellCommand", "commandLine", "", "component1", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "createBundledCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "toString", "intellij.vcs.git"})
    public static final class Local
    extends GitExecutable {
        @NotNull
        private final String exePath;
        @NotNull
        private final String id;
        private final boolean isLocal;

        public Local(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            super(null);
            this.exePath = exePath;
            this.id = "local";
            this.isLocal = true;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String string = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            return string;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (SystemInfo.isWindows && StringsKt.startsWith$default((String)path, (String)GitExecutable.CYGDRIVE_PREFIX, (boolean)false, (int)2, null)) {
                int prefixSize = 10;
                String string = path.substring(prefixSize, prefixSize + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string2 = path.substring(prefixSize + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String localPath = string + ":" + string2;
                return new File(localPath);
            }
            return FilesKt.resolve((File)workingDir, (String)path);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            if (executableContext.isWithLowPriority()) {
                ExecUtil.setupLowPriorityExecution((GeneralCommandLine)commandLine);
            }
            if (executableContext.isWithNoTty()) {
                ExecUtil.setupNoTtyExecution((GeneralCommandLine)commandLine);
            }
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@Nullable Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (SystemInfo.isWindows) {
                String string = GitExecutableDetector.getBashExecutablePath(this.getExePath());
                if (string == null) {
                    throw new ExecutionException(GitBundle.message("git.executable.error.bash.not.found", new Object[0]));
                }
                String bashPath = string;
                String[] stringArray = new String[]{"-c"};
                GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(bashPath).withParameters(stringArray);
                stringArray = new String[]{this.buildShellCommand(ArraysKt.toList((Object[])command))};
                GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"GeneralCommandLine()\n   \u2026ommand(command.toList()))");
                return generalCommandLine2;
            }
            return new GeneralCommandLine(Arrays.copyOf(command, command.length));
        }

        private final String buildShellCommand(List<String> commandLine) {
            return CollectionsKt.joinToString$default((Iterable)commandLine, (CharSequence)" ", null, null, (int)0, null, (Function1)buildShellCommand.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final String component1() {
            return this.getExePath();
        }

        @NotNull
        public final Local copy(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            return new Local(exePath);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.getExePath();
            }
            return local.copy(string);
        }

        public int hashCode() {
            return this.getExePath().hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return Intrinsics.areEqual((Object)this.getExePath(), (Object)local.getExePath());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J+\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001e\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0016J$\u0010,\u001a\u00020&2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000f\u00a8\u00060"}, d2={"Lgit4idea/config/GitExecutable$Wsl;", "Lgit4idea/config/GitExecutable;", "exePath", "", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "(Ljava/lang/String;Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "component1", "component2", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "createBundledCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "executableContext", "Lgit4idea/config/GitExecutableContext;", "patchWslExecutable", "wslOptions", "Lcom/intellij/execution/wsl/WSLCommandLineOptions;", "toString", "intellij.vcs.git"})
    public static final class Wsl
    extends GitExecutable {
        @NotNull
        private final String exePath;
        @NotNull
        private final WSLDistribution distribution;
        @NotNull
        private final String id;
        private final boolean isLocal;

        public Wsl(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            super(null);
            this.exePath = exePath;
            this.distribution = distribution;
            this.id = "wsl-" + this.distribution.getId();
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final WSLDistribution getDistribution() {
            return this.distribution;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.distribution.getPresentableName() + ": " + this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file2) {
            String wslPath;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String path = file2.getAbsolutePath();
            String string = wslPath = this.distribution.getWslPath(path);
            if (string != null) {
                return string;
            }
            File file3 = this.distribution.getUNCRoot();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"distribution.uncRoot");
            File uncRoot = file3;
            if (FileUtil.isAncestor((File)uncRoot, (File)file2, (boolean)false)) {
                String string2 = StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)uncRoot.getPath()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(FileUtil.toSys\u2026endentName(uncRoot.path))");
                return string2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            return path;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            String string = this.distribution.getWindowsPath(path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"distribution.getWindowsPath(path)");
            String localPath = string;
            return new File(localPath);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            if (executableContext.isWithNoTty()) {
                String string = commandLine.getExePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine.exePath");
                String executablePath = string;
                commandLine.setExePath("setsid");
                if (Registry.is((String)"git.use.setsid.wait.for.wsl.ssh")) {
                    String[] stringArray = new String[]{"-w", executablePath};
                    commandLine.getParametersList().prependAll(stringArray);
                } else {
                    String[] stringArray = new String[]{executablePath};
                    commandLine.getParametersList().prependAll(stringArray);
                }
            }
            this.patchWslExecutable(handler.project(), commandLine, executableContext.getWslOptions());
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@Nullable Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            GeneralCommandLine commandLine = new GeneralCommandLine(Arrays.copyOf(command, command.length));
            this.patchWslExecutable(project, commandLine, null);
            return commandLine;
        }

        private final void patchWslExecutable(Project project, GeneralCommandLine commandLine, WSLCommandLineOptions wslOptions) {
            WSLCommandLineOptions options;
            WSLCommandLineOptions wSLCommandLineOptions = wslOptions;
            if (wSLCommandLineOptions == null) {
                wSLCommandLineOptions = options = new WSLCommandLineOptions();
            }
            if (Registry.is((String)"git.wsl.exe.executable.no.shell")) {
                options.setLaunchWithWslExe(true);
                options.setExecuteCommandInShell(false);
                options.setPassEnvVarsUsingInterop(true);
            }
            this.distribution.patchCommandLine(commandLine, project, options);
        }

        @NotNull
        public final String component1() {
            return this.getExePath();
        }

        @NotNull
        public final WSLDistribution component2() {
            return this.distribution;
        }

        @NotNull
        public final Wsl copy(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            return new Wsl(exePath, distribution);
        }

        public static /* synthetic */ Wsl copy$default(Wsl wsl, String string, WSLDistribution wSLDistribution, int n, Object object) {
            if ((n & 1) != 0) {
                string = wsl.getExePath();
            }
            if ((n & 2) != 0) {
                wSLDistribution = wsl.distribution;
            }
            return wsl.copy(string, wSLDistribution);
        }

        public int hashCode() {
            int result2 = this.getExePath().hashCode();
            result2 = result2 * 31 + this.distribution.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Wsl)) {
                return false;
            }
            Wsl wsl = (Wsl)other;
            if (!Intrinsics.areEqual((Object)this.getExePath(), (Object)wsl.getExePath())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.distribution, (Object)wsl.distribution);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J,\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J+\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001e\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016R\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006-"}, d2={"Lgit4idea/config/GitExecutable$Unknown;", "Lgit4idea/config/GitExecutable;", "id", "", "exePath", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "getExePath", "getId", "isLocal", "", "()Z", "component1", "component2", "component3", "convertFilePath", "file", "Ljava/io/File;", "convertFilePathBack", "path", "workingDir", "copy", "createBundledCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "equals", "other", "", "hashCode", "", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "executableContext", "Lgit4idea/config/GitExecutableContext;", "toString", "intellij.vcs.git"})
    public static final class Unknown
    extends GitExecutable {
        @NotNull
        private final String id;
        @NotNull
        private final String exePath;
        @NotNull
        private final String errorMessage;
        private final boolean isLocal;

        public Unknown(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            super(null);
            this.id = id;
            this.exePath = exePath;
            this.errorMessage = errorMessage;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.getId() + ": " + this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String string = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            return string;
        }

        @Override
        @NotNull
        public File convertFilePathBack(@NotNull String path, @NotNull File workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            return new File(path);
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            throw new ExecutionException(this.errorMessage);
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@Nullable Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            throw new ExecutionException(this.errorMessage);
        }

        @NotNull
        public final String component1() {
            return this.getId();
        }

        @NotNull
        public final String component2() {
            return this.getExePath();
        }

        @NotNull
        public final String component3() {
            return this.errorMessage;
        }

        @NotNull
        public final Unknown copy(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            return new Unknown(id, exePath, errorMessage);
        }

        public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknown.getId();
            }
            if ((n & 2) != 0) {
                string2 = unknown.getExePath();
            }
            if ((n & 4) != 0) {
                string3 = unknown.errorMessage;
            }
            return unknown.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.getId().hashCode();
            result2 = result2 * 31 + this.getExePath().hashCode();
            result2 = result2 * 31 + this.errorMessage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown unknown = (Unknown)other;
            if (!Intrinsics.areEqual((Object)this.getId(), (Object)unknown.getId())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getExePath(), (Object)unknown.getExePath())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)unknown.errorMessage);
        }
    }
}

