/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class GitSimpleHandler
extends GitTextHandler {
    private final StringBuilder myStderr = new StringBuilder();
    private final StringBuilder myStderrLine = new StringBuilder();
    private final StringBuilder myStdout = new StringBuilder();
    private final StringBuilder myStdoutLine = new StringBuilder();
    private final HashSet<Integer> myIgnoredErrorCodes = new HashSet();

    public GitSimpleHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command);
    }

    public GitSimpleHandler(@NotNull Project project, @NotNull VirtualFile directory, @NotNull GitCommand command) {
        super(project, directory, command);
    }

    @Override
    protected void processTerminated(int exitCode) {
        String stdout = this.myStdoutLine.toString();
        String stderr = this.myStderrLine.toString();
        if (!this.isStdoutSuppressed() && !StringUtil.isEmptyOrSpaces((String)stdout)) {
            LOG.info(stdout.trim());
            this.myStdoutLine.setLength(0);
        } else if (!this.isStderrSuppressed() && !StringUtil.isEmptyOrSpaces((String)stderr)) {
            LOG.info(stderr.trim());
            this.myStderrLine.setLength(0);
        } else {
            LOG.debug(stderr.trim());
        }
    }

    protected void onTextAvailable(String text, Key outputType) {
        boolean suppressed;
        StringBuilder lineRest;
        StringBuilder entire;
        if (ProcessOutputTypes.STDOUT == outputType) {
            entire = this.myStdout;
            lineRest = this.myStdoutLine;
            suppressed = this.isStdoutSuppressed();
        } else if (ProcessOutputTypes.STDERR == outputType) {
            entire = this.myStderr;
            lineRest = this.myStderrLine;
            suppressed = this.isStderrSuppressed();
        } else {
            return;
        }
        entire.append(text);
        if (suppressed && !LOG.isDebugEnabled()) {
            return;
        }
        char last = lineRest.length() > 0 ? (char)lineRest.charAt(lineRest.length() - 1) : (char)'\uffffffff';
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (last == '\n' || last == '\r') {
                int savedPos = (ch == '\n' || ch == '\r') && ch != last ? i - 1 : i;
                if (last != '\r' || savedPos != i) {
                    String line;
                    if (lineRest.length() == 0) {
                        line = lineRest.append(text, start, savedPos).toString();
                        lineRest.setLength(0);
                    } else {
                        line = text.substring(start, savedPos);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)line)) {
                        if (!suppressed) {
                            LOG.info(line.trim());
                        } else {
                            LOG.debug(line.trim());
                        }
                    }
                }
                start = savedPos;
            }
            last = ch;
        }
        if (start != text.length()) {
            lineRest.append(text.substring(start));
        }
    }

    @NlsSafe
    public String getStderr() {
        return this.myStderr.toString();
    }

    @NlsSafe
    public String getStdout() {
        return this.myStdout.toString();
    }

    @NlsSafe
    public String run() throws VcsException {
        final Ref exRef = Ref.create();
        final Ref resultRef = Ref.create();
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                try {
                    if (exitCode == 0 || GitSimpleHandler.this.isIgnoredErrorCode(exitCode)) {
                        resultRef.set((Object)GitSimpleHandler.this.getStdout());
                    } else {
                        String msg = GitSimpleHandler.this.getStderr();
                        if (msg.length() == 0) {
                            msg = GitSimpleHandler.this.getStdout();
                        }
                        if (msg.length() == 0) {
                            msg = GitBundle.message("git.error.exit", exitCode);
                        }
                        exRef.set((Object)new VcsException(msg));
                    }
                }
                catch (Throwable t) {
                    exRef.set((Object)new VcsException(t.toString(), t));
                }
            }

            public void startFailed(@NotNull Throwable exception) {
                exRef.set((Object)new VcsException(GitBundle.message("git.executable.unknown.error.message", exception.getMessage()), exception));
            }
        });
        try {
            this.runInCurrentThread();
        }
        catch (IOException e) {
            exRef.set((Object)new VcsException(e.getMessage(), (Throwable)e));
        }
        if (!exRef.isNull()) {
            throw (VcsException)((Object)exRef.get());
        }
        if (resultRef.isNull()) {
            throw new VcsException(GitBundle.message("git.error.cant.process.output", this.printableCommandLine()));
        }
        return (String)resultRef.get();
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        OSProcessHandler process = super.createProcess(commandLine);
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                GitSimpleHandler.this.onTextAvailable(event.getText(), outputType);
            }
        });
        return process;
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }
}

