/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.externalProcessAuthHelper.ScriptGeneratorImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import externalApp.ExternalApp;
import git4idea.config.GitExecutable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GitScriptGenerator
extends ScriptGeneratorImpl {
    private final GitExecutable myExecutable;

    public GitScriptGenerator(@NotNull GitExecutable executable) {
        this.myExecutable = executable;
    }

    @NotNull
    protected String getJavaExecutablePath() {
        if (this.myExecutable instanceof GitExecutable.Wsl) {
            File javaExecutable = new File(String.format("%s\\bin\\java.exe", System.getProperty("java.home")));
            return this.myExecutable.convertFilePath(javaExecutable);
        }
        return super.getJavaExecutablePath();
    }

    @NotNull
    public String commandLine(@NotNull Class<? extends ExternalApp> mainClass, boolean useBatchFile) {
        String commandLine = super.commandLine(mainClass, useBatchFile);
        if (this.myExecutable instanceof GitExecutable.Wsl) {
            StringBuilder sb = new StringBuilder();
            ArrayList envs = ContainerUtil.newArrayList((Object[])new String[]{"INTELLIJ_SSH_ASKPASS_HANDLER", "INTELLIJ_SSH_ASKPASS_PORT", "GIT_ASKPASS_HANDLER", "GIT_ASKPASS_PORT", "IDEA_REBASE_HANDER_NO"});
            sb.append("export WSLENV=");
            sb.append(StringUtil.join((Collection)envs, it -> it + "/w", (String)":"));
            sb.append("\n");
            sb.append(commandLine);
            return sb.toString();
        }
        return commandLine;
    }
}

