/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.io.BaseDataReader;
import git4idea.commands.BufferingTextSplitter;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitExecutable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLineHandler
extends GitTextHandler {
    private final EventDispatcher<GitLineHandlerListener> myLineListeners = EventDispatcher.create(GitLineHandlerListener.class);
    @NotNull
    private Collection<String> myUrls = Collections.emptyList();
    @NotNull
    private AuthenticationMode myIgnoreAuthenticationRequest = AuthenticationMode.FULL;
    @Nullable
    private AuthenticationGate myAuthenticationGate;

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command);
    }

    public GitLineHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        super(project, vcsRoot, command);
    }

    public GitLineHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, vcsRoot, command, configParameters);
    }

    public GitLineHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, directory, executable, command, configParameters);
    }

    public void setUrl(@NotNull @NonNls String url) {
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        this.myUrls = urls;
    }

    @NotNull
    public Collection<String> getUrls() {
        return this.myUrls;
    }

    protected boolean isRemote() {
        return !this.myUrls.isEmpty();
    }

    @NotNull
    public AuthenticationMode getIgnoreAuthenticationMode() {
        return this.myIgnoreAuthenticationRequest;
    }

    public void setIgnoreAuthenticationMode(@NotNull AuthenticationMode authenticationMode) {
        this.myIgnoreAuthenticationRequest = authenticationMode;
    }

    @Deprecated(forRemoval=true)
    public void setIgnoreAuthenticationMode(@NotNull GitAuthenticationMode authenticationMode) {
        this.myIgnoreAuthenticationRequest = switch (authenticationMode) {
            default -> throw new IncompatibleClassChangeError();
            case GitAuthenticationMode.NONE -> AuthenticationMode.NONE;
            case GitAuthenticationMode.SILENT -> AuthenticationMode.SILENT;
            case GitAuthenticationMode.FULL -> AuthenticationMode.FULL;
        };
    }

    @Nullable
    public AuthenticationGate getAuthenticationGate() {
        return this.myAuthenticationGate;
    }

    public void setAuthenticationGate(@NotNull AuthenticationGate authenticationGate) {
        this.myAuthenticationGate = authenticationGate;
    }

    @Override
    protected void processTerminated(int exitCode) {
    }

    public void addLineListener(GitLineHandlerListener listener2) {
        super.addListener((ProcessEventListener)listener2);
        this.myLineListeners.addListener((EventListener)((Object)listener2));
    }

    private void onLineAvailable(@NotNull String line, boolean isCr, @NotNull Key outputType) {
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        if (!isCr) {
            this.logOutput(line, outputType);
        }
        if (OUTPUT_LOG.isDebugEnabled()) {
            OUTPUT_LOG.debug(String.format("%s %% %s (%s):'%s'", this.getCommand(), this.hashCode(), outputType, line));
        }
        ((GitLineHandlerListener)((Object)this.myLineListeners.getMulticaster())).onLineAvailable(line, outputType);
    }

    private void logOutput(@NotNull String line, @NotNull Key outputType) {
        boolean shouldLogOutput;
        if (this.mySilent) {
            return;
        }
        boolean bl = shouldLogOutput = outputType == ProcessOutputTypes.STDOUT && !this.isStdoutSuppressed() || outputType == ProcessOutputTypes.STDERR && !this.isStderrSuppressed();
        if (!shouldLogOutput) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)line)) {
            return;
        }
        LOG.info(line.trim());
    }

    @Override
    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new GitTextHandler.MyOSProcessHandler(commandLine, this.myWithMediator && this.myExecutable.isLocal() && Registry.is((String)"git.execute.with.mediator")){

            @NotNull
            protected BaseDataReader createOutputDataReader() {
                return new LineReader(this.createProcessOutReader(), this.readerOptions().policy(), new BufferingTextSplitter((line, isCr) -> GitLineHandler.this.onLineAvailable(line, isCr, ProcessOutputTypes.STDOUT)), this.myPresentableName);
            }

            @NotNull
            protected BaseDataReader createErrorDataReader() {
                return new LineReader(this.createProcessErrReader(), this.readerOptions().policy(), new BufferingTextSplitter((line, isCr) -> GitLineHandler.this.onLineAvailable(line, isCr, ProcessOutputTypes.STDERR)), this.myPresentableName);
            }
        };
    }

    public void overwriteConfig(String ... params) {
        this.overwriteConfig(Arrays.asList(params));
    }

    public void overwriteConfig(@NonNls List<String> params) {
        for (String param : params) {
            this.myCommandLine.getParametersList().prependAll(new String[]{"-c", param});
        }
    }

    private static class LineReader
    extends BaseDataReader {
        @NotNull
        private final Reader myReader;
        private final char @NotNull [] myInputBuffer = new char[8192];
        @NotNull
        private final BufferingTextSplitter myOutputProcessor;

        LineReader(@NotNull Reader reader, @NotNull BaseDataReader.SleepingPolicy sleepingPolicy, @NotNull BufferingTextSplitter outputProcessor, @NotNull String presentableName) {
            super(sleepingPolicy);
            this.myReader = reader;
            this.myOutputProcessor = outputProcessor;
            this.start(presentableName);
        }

        protected boolean readAvailableNonBlocking() throws IOException {
            return this.read(true);
        }

        protected boolean readAvailableBlocking() throws IOException {
            return this.read(false);
        }

        private boolean read(boolean checkReaderReady) throws IOException {
            int n;
            boolean read = false;
            while ((!checkReaderReady || this.myReader.ready()) && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read = true;
                this.myOutputProcessor.process(this.myInputBuffer, n);
            }
            return read;
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return ProcessIOExecutorService.INSTANCE.submit(runnable);
        }

        protected void close() throws IOException {
            try {
                this.myReader.close();
            }
            finally {
                this.myOutputProcessor.flush();
            }
        }
    }
}

