/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerAuthenticationManager;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitSimpleEditorHandler;
import git4idea.rebase.GitUnstructuredEditor;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitImplBase
implements Git {
    private static final Logger LOG = Logger.getInstance(GitImplBase.class);
    private static final Pattern PROGRESS_PATTERN = Pattern.compile(".*:\\s*\\d{1,3}% \\(\\d+/\\d+\\).*");
    @NonNls
    private static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    @NonNls
    private static final String[] SUPPRESSED_PROGRESS_INDICATORS = new String[]{"Counting objects: ", "Enumerating objects: ", "Compressing objects: ", "Writing objects: ", "Receiving objects: ", "Resolving deltas: ", "Finding sources: ", "Updating files: ", "Checking out files: ", "Expanding reachable commits in commit graph: ", "Delta compression using up to "};
    @NonNls
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        return GitImplBase.run(handler, GitImplBase.getCollectingCollector());
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<? extends GitLineHandler> handlerConstructor) {
        return GitImplBase.run(handlerConstructor, (Computable<? extends OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        return new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (Registry.is((String)"git.allow.stderr.to.stdout.mixing") && !GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }
        };
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        return GitImplBase.run(handler, new OutputCollector(){

            @Override
            protected void outputLineReceived(@NotNull String line) {
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                this.addErrorLine(line);
            }
        });
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<? extends GitLineHandler> handlerConstructor, @NotNull Computable<? extends OutputCollector> outputCollectorConstructor) {
        GitCommandResult result2;
        int authAttempt = 0;
        do {
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            OutputCollector outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            boolean isCredHelperUsed = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            result2 = GitImplBase.run(handler, outputCollector);
            if (isCredHelperUsed != GitVcsApplicationSettings.getInstance().isUseCredentialHelper()) continue;
            ++authAttempt;
        } while (result2.isAuthenticationFailed() && authAttempt < 2);
        return result2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        Project project;
        GitVersion version = GitVersion.NULL;
        if (handler.isPreValidateExecutable()) {
            GitExecutable executable = handler.getExecutable();
            try {
                version = GitExecutableManager.getInstance().identifyVersion(executable);
                if (version.getType() == GitVersion.Type.WSL1 && !Registry.is((String)"git.allow.wsl1.executables")) {
                    throw new GitNotInstalledException(GitBundle.message("executable.error.git.not.installed", new Object[0]), null);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                return GitImplBase.handlePreValidationException(handler.project(), e);
            }
        }
        if ((project = handler.project()) != null && project.isDisposed()) {
            LOG.warn("Project has already been disposed");
            throw new ProcessCanceledException();
        }
        if (project != null) {
            try (GitHandlerAuthenticationManager authenticationManager = GitHandlerAuthenticationManager.prepare(project, handler, version);){
                GitHandlerRebaseEditorManager ignored = GitImplBase.prepareGeneralPurposeEditor(project, handler);
                try {
                    GitCommandResult result2 = GitImplBase.doRun(handler, version, outputCollector);
                    GitCommandResult gitCommandResult = GitCommandResult.withAuthentication(result2, authenticationManager.isHttpAuthFailed());
                    if (ignored != null) {
                        ignored.close();
                    }
                    return gitCommandResult;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return GitCommandResult.startError(GitBundle.message("git.executable.unknown.error.message", e.getLocalizedMessage()));
            }
        }
        return GitImplBase.doRun(handler, version, outputCollector);
    }

    @NotNull
    private static GitHandlerRebaseEditorManager prepareGeneralPurposeEditor(@NotNull Project project, @NotNull GitLineHandler handler) {
        return GitHandlerRebaseEditorManager.prepareEditor(handler, new GitSimpleEditorHandler(project));
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull GitVersion version, @NotNull OutputCollector outputCollector) {
        boolean canSuppressOptionalLocks;
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        boolean bl = canSuppressOptionalLocks = Registry.is((String)"git.use.no.optional.locks") && GitVersionSpecialty.ENV_GIT_OPTIONAL_LOCKS_ALLOWED.existsIn(version);
        if (canSuppressOptionalLocks) {
            handler.addCustomEnvironmentVariable("GIT_OPTIONAL_LOCKS", "0");
        }
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler, canSuppressOptionalLocks);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            return GitCommandResult.error(GitBundle.message("git.error.cant.process.output", e.getLocalizedMessage()));
        }
        return new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput);
    }

    @NotNull
    public static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        HashMap<@NonNls String, @NonNls String> environment = new HashMap<String, String>(5);
        int logLevel = Registry.intValue((String)"git.execution.trace");
        if (logLevel == 0) {
            environment.put("GIT_TRACE", "0");
            if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
                environment.put("GIT_TRACE_PACK_ACCESS", "");
            }
            environment.put("GIT_TRACE_PACKET", "");
            environment.put("GIT_TRACE_PERFORMANCE", "0");
            environment.put("GIT_TRACE_SETUP", "0");
        } else {
            String logFile = PathManager.getLogPath() + "/gittrace.log";
            if ((logLevel & 1) == 1) {
                environment.put("GIT_TRACE", logFile);
            }
            if ((logLevel & 2) == 2) {
                environment.put("GIT_TRACE_PACK_ACCESS", logFile);
            }
            if ((logLevel & 4) == 4) {
                environment.put("GIT_TRACE_PACKET", logFile);
            }
            if ((logLevel & 8) == 8) {
                environment.put("GIT_TRACE_PERFORMANCE", logFile);
            }
            if ((logLevel & 0x10) == 16) {
                environment.put("GIT_TRACE_SETUP", logFile);
            }
        }
        return environment;
    }

    @RequiresBackgroundThread
    public static boolean loadFileAndShowInSimpleEditor(@NotNull Project project, @Nullable VirtualFile root, @NotNull File file2, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull @NlsContexts.Button String okButtonText) throws IOException {
        String encoding = root == null ? "UTF-8" : GitConfigUtil.getCommitEncoding(project, root);
        String initialText = StringUtil.trimLeading((String)GitImplBase.ignoreComments(FileUtil.loadFile((File)file2, (String)encoding)));
        String newText = GitImplBase.showUnstructuredEditorAndWait(project, root, initialText, dialogTitle, okButtonText);
        if (newText == null) {
            return false;
        }
        FileUtil.writeToFile((File)file2, (byte[])newText.getBytes(encoding));
        return true;
    }

    @Nullable
    private static String showUnstructuredEditorAndWait(@NotNull Project project, @Nullable VirtualFile root, @NotNull @NlsSafe String initialText, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull @NlsContexts.Button String okButtonText) {
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitUnstructuredEditor editor = new GitUnstructuredEditor(project, root, initialText, dialogTitle, okButtonText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    @NotNull
    private static String ignoreComments(@NotNull String text) {
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
        return ((StreamEx)StreamEx.of((Object[])lines).filter(line -> !line.startsWith("\u0001"))).joining();
    }

    @NotNull
    private static GitCommandResult handlePreValidationException(@Nullable Project project, @NotNull Exception e) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (project != null && progressIndicator != null && !progressIndicator.getModalityState().dominates(ModalityState.NON_MODAL)) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            throw new ProcessCanceledException((Throwable)e);
        }
        return GitCommandResult.startError(GitBundle.message("git.executable.validation.error.start.title", new Object[0]) + ": \n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e));
    }

    private static void writeOutputToConsole(@NotNull GitLineHandler handler) {
        if (handler.isSilent()) {
            return;
        }
        Project project = handler.project();
        if (project != null && !project.isDefault()) {
            String workingDir = GitImplBase.stringifyWorkingDir(project.getBasePath(), handler.getWorkingDirectory());
            GitVcsConsoleWriter.getInstance(project).showCommandLine(String.format("[%s] %s", workingDir, handler.printableCommandLine()));
            handler.addLineListener(new GitCommandOutputLogger(project, handler));
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler, boolean canSuppressOptionalLocks) {
        Project project = handler.project();
        GitCommand.LockingPolicy lockingPolicy = handler.getCommand().lockingPolicy();
        if (project == null || project.isDefault() || lockingPolicy == GitCommand.LockingPolicy.READ) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
        final Lock lock = lockingPolicy == GitCommand.LockingPolicy.READ_OPTIONAL_LOCKING && canSuppressOptionalLocks ? executionLock.readLock() : executionLock.writeLock();
        lock.lock();
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    public static boolean looksLikeProgress(@NotNull String line) {
        if (PROGRESS_PATTERN.matcher(line).matches()) {
            return true;
        }
        return ContainerUtil.exists((Object[])SUPPRESSED_PROGRESS_INDICATORS, prefix -> {
            if (StringUtil.startsWith((CharSequence)line, (CharSequence)prefix)) {
                return true;
            }
            if (StringUtil.startsWith((CharSequence)line, (CharSequence)REMOTE_PROGRESS_PREFIX)) {
                return StringUtil.startsWith((CharSequence)line, (int)REMOTE_PROGRESS_PREFIX.length(), (CharSequence)prefix);
            }
            return false;
        });
    }

    private static boolean looksLikeError(@NotNull @NonNls String text) {
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> StringUtil.startsWithIgnoreCase((String)text.trim(), (String)indicator));
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @NotNull File workingDir) {
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)workingDir.getPath()), (char)'/');
            if (".".equals(relPath)) {
                return workingDir.getName();
            }
            if (relPath != null) {
                return FileUtil.toSystemDependentName((String)relPath);
            }
        }
        return workingDir.getPath();
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            List<String> list2 = this.myOutput;
            synchronized (list2) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            List<String> list2 = this.myErrorOutput;
            synchronized (list2) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR && !GitImplBase.looksLikeProgress(line)) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(@NotNull Throwable t) {
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived(GitBundle.message("git.executable.unknown.error.message", t.getLocalizedMessage()));
        }
    }

    private static class GitCommandOutputLogger
    implements GitLineHandlerListener {
        @NotNull
        private final GitLineHandler myHandler;
        private final GitVcsConsoleWriter myVcsConsoleWriter;
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;

        GitCommandOutputLogger(@NotNull Project project, @NotNull GitLineHandler handler) {
            this.myHandler = handler;
            this.myVcsConsoleWriter = GitVcsConsoleWriter.getInstance(project);
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            try {
                if (StringUtil.isEmptyOrSpaces((String)line)) {
                    return;
                }
                if (outputType == ProcessOutputTypes.SYSTEM) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDOUT && this.myHandler.isStdoutSuppressed()) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && this.myHandler.isStderrSuppressed()) {
                    return;
                }
                ArrayList<Pair<String, Key>> lineChunks = new ArrayList<Pair<String, Key>>();
                this.myAnsiEscapeDecoder.escapeText(line, outputType, (text, key) -> lineChunks.add(Pair.create((Object)text, (Object)key)));
                this.myVcsConsoleWriter.showMessage(lineChunks);
            }
            catch (ProcessCanceledException lineChunks) {
            }
            catch (Exception e) {
                throw new RuntimeException("Logging error for " + this.myHandler, e);
            }
        }
    }
}

