/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.externalProcessAuthHelper.XmlRpcHandlerService;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.http.GitAskPassApp;
import git4idea.http.GitAskPassXmlRpcHandler;
import java.io.File;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class GitHttpAuthService
extends XmlRpcHandlerService<GitHttpAuthenticator> {
    protected static final GitHttpAuthenticator STUB_AUTHENTICATOR = new GitHttpAuthenticator(){

        @Override
        @NotNull
        public String askPassword(@NotNull String url) {
            return "";
        }

        @Override
        @NotNull
        public String askUsername(@NotNull String url) {
            return "";
        }

        @Override
        public void saveAuthData() {
        }

        @Override
        public void forgetPassword() {
        }

        @Override
        public boolean wasCancelled() {
            return false;
        }

        @Override
        public boolean wasRequested() {
            return false;
        }
    };

    protected GitHttpAuthService() {
        super("intellij-git-askpass", GitAskPassXmlRpcHandler.HANDLER_NAME, GitAskPassApp.class);
    }

    @NotNull
    protected Object createRpcRequestHandlerDelegate() {
        return new InternalRequestHandlerDelegate();
    }

    @NotNull
    public abstract GitHttpAuthenticator createAuthenticator(@NotNull Project var1, @NotNull Collection<String> var2, @NotNull File var3, @NotNull AuthenticationGate var4, @NotNull AuthenticationMode var5);

    private static String parseUrl(@NotNull String url) {
        url = StringUtil.trimStart((String)url, (String)"'");
        url = StringUtil.trimEnd((String)url, (String)":");
        url = StringUtil.trimEnd((String)url, (String)"'");
        return url;
    }

    @NotNull
    public static <T> T getDefaultValueIfCancelled(@NotNull Computable<? extends T> operation, @NotNull T defaultValue) {
        try {
            return (T)operation.compute();
        }
        catch (ProcessCanceledException pce) {
            return defaultValue;
        }
    }

    public class InternalRequestHandlerDelegate
    implements GitAskPassXmlRpcHandler {
        @NotNull
        public String handleInput(@NotNull String handlerNo, @NotNull String arg) {
            GitHttpAuthenticator handler = (GitHttpAuthenticator)GitHttpAuthService.this.getHandler(UUID.fromString(handlerNo));
            boolean usernameNeeded = StringUtilRt.startsWithIgnoreCase((String)arg, (String)"username");
            String[] split = arg.split(" ");
            String url = split.length > 2 ? GitHttpAuthService.parseUrl(split[2]) : "";
            return GitHttpAuthService.getDefaultValueIfCancelled(() -> usernameNeeded ? handler.askUsername(url) : handler.askPassword(url), "");
        }
    }
}

