/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsEnvCustomizer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConsumer;
import com.intellij.vcs.VcsLocaleHelper;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitImplBase;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableContext;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitHandler {
    protected static final Logger LOG = Logger.getInstance(GitHandler.class);
    protected static final Logger OUTPUT_LOG = Logger.getInstance((String)("#output." + GitHandler.class.getName()));
    private static final Logger TIME_LOG = Logger.getInstance((String)("#time." + GitHandler.class.getName()));
    private final Project myProject;
    @NotNull
    protected final GitExecutable myExecutable;
    private final GitCommand myCommand;
    private boolean myPreValidateExecutable = true;
    protected final GeneralCommandLine myCommandLine;
    private final Map<String, String> myCustomEnv = new HashMap<String, String>();
    protected Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    @Nullable
    private ThrowableConsumer<? super OutputStream, IOException> myInputProcessor;
    private final EventDispatcher<ProcessEventListener> myListeners = EventDispatcher.create(ProcessEventListener.class);
    protected boolean mySilent;
    private final GitExecutableContext myExecutableContext;
    private long myStartTime;
    private static final long LONG_TIME = 10000L;
    @Deprecated
    private Integer myExitCode;
    @Deprecated
    private final List<String> myLastOutput = Collections.synchronizedList(new ArrayList());
    @Deprecated
    private static final int LAST_OUTPUT_SIZE = 5;
    @Deprecated
    private final List<VcsException> myErrors = Collections.synchronizedList(new ArrayList());

    protected GitHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        this(project, directory, GitExecutableManager.getInstance().getExecutable(project), command, configParameters);
    }

    protected GitHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        this(project, VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), command, configParameters);
    }

    protected GitHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        this.myProject = project;
        this.myExecutable = executable;
        this.myCommand = command;
        this.myCommandLine = new GeneralCommandLine().withWorkDirectory(directory).withExePath(executable.getExePath()).withCharset(StandardCharsets.UTF_8);
        for (String parameter : GitHandler.getConfigParameters(project, configParameters)) {
            this.myCommandLine.addParameters(new String[]{"-c", parameter});
        }
        this.myCommandLine.addParameter(command.name());
        this.myStdoutSuppressed = true;
        this.mySilent = this.myCommand.lockingPolicy() != GitCommand.LockingPolicy.WRITE;
        GitVcs gitVcs = this.myProject != null ? GitVcs.getInstance(this.myProject) : null;
        VirtualFile root = VfsUtil.findFileByIoFile((File)directory, (boolean)true);
        VcsEnvCustomizer.ExecutableType executableType = this.myExecutable instanceof GitExecutable.Wsl ? VcsEnvCustomizer.ExecutableType.WSL : VcsEnvCustomizer.ExecutableType.LOCAL;
        this.myExecutableContext = new GitExecutableContext(gitVcs, root, executableType);
    }

    private static @NotNull List<@NonNls String> getConfigParameters(@Nullable Project project, @NotNull List<@NonNls String> requestedConfigParameters) {
        if (project == null || !GitVersionSpecialty.CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND.existsIn(project)) {
            return Collections.emptyList();
        }
        ArrayList<@NonNls String> toPass = new ArrayList<String>();
        toPass.add("core.quotepath=false");
        toPass.add("log.showSignature=false");
        toPass.addAll(requestedConfigParameters);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            toPass.add("protocol.file.allow=always");
        }
        return toPass;
    }

    @NotNull
    protected ProcessEventListener listeners() {
        return (ProcessEventListener)this.myListeners.getMulticaster();
    }

    @Nullable
    public Project project() {
        return this.myProject;
    }

    @NotNull
    File getWorkingDirectory() {
        return this.myCommandLine.getWorkDirectory();
    }

    public VcsEnvCustomizer.VcsExecutableContext getExecutableContext() {
        return this.myExecutableContext;
    }

    @NotNull
    public GitExecutable getExecutable() {
        return this.myExecutable;
    }

    @NotNull
    GitCommand getCommand() {
        return this.myCommand;
    }

    protected void addListener(@NotNull ProcessEventListener listener2) {
        this.myListeners.addListener((EventListener)listener2);
    }

    public void withLowPriority() {
        this.myExecutableContext.withLowPriority(true);
    }

    public void withNoTty() {
        this.myExecutableContext.withNoTty(true);
    }

    public void addParameters(String ... parameters) {
        this.addParameters(Arrays.asList(parameters));
    }

    public void addParameters(@NotNull List<@NonNls String> parameters) {
        for (String parameter : parameters) {
            this.myCommandLine.addParameter(this.escapeParameterIfNeeded(parameter));
        }
    }

    @NotNull
    private String escapeParameterIfNeeded(@NotNull @NonNls String parameter) {
        if (this.escapeNeeded(parameter)) {
            return parameter.replaceAll("\\^", "^^^^");
        }
        return parameter;
    }

    private boolean escapeNeeded(@NotNull @NonNls String parameter) {
        return SystemInfo.isWindows && this.isCmd() && parameter.contains("^");
    }

    private boolean isCmd() {
        return StringUtil.toLowerCase((String)this.myCommandLine.getExePath()).endsWith("cmd");
    }

    public void addRelativePaths(FilePath ... parameters) {
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<? extends FilePath> filePaths) {
        for (FilePath filePath : filePaths) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (FilePath)filePath));
        }
    }

    public void addRelativeFiles(@NotNull Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (VirtualFile)virtualFile));
        }
    }

    public void addAbsoluteFile(@NotNull File file2) {
        this.myCommandLine.addParameter(this.myExecutable.convertFilePath(file2));
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    private boolean isStarted() {
        return this.myProcess != null;
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }

    @NlsSafe
    public String printableCommandLine() {
        return this.unescapeCommandLine(this.myCommandLine.getCommandLineString("git"));
    }

    @NotNull
    private String unescapeCommandLine(@NotNull String commandLine) {
        if (this.escapeNeeded(commandLine)) {
            return commandLine.replaceAll("\\^\\^\\^\\^", "^");
        }
        return commandLine;
    }

    @NotNull
    public Charset getCharset() {
        return this.myCommandLine.getCharset();
    }

    public void setCharset(@NotNull Charset charset) {
        this.myCommandLine.setCharset(charset);
    }

    public void setSilent(boolean silent) {
        this.mySilent = silent;
        if (silent) {
            this.setStderrSuppressed(true);
            this.setStdoutSuppressed(true);
        }
    }

    boolean isSilent() {
        return this.mySilent;
    }

    boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setInputProcessor(@Nullable ThrowableConsumer<? super OutputStream, IOException> inputProcessor) {
        this.myInputProcessor = inputProcessor;
    }

    public void addCustomEnvironmentVariable(@NotNull @NonNls String name, @Nullable @NonNls String value) {
        this.myCustomEnv.put(name, value);
    }

    public void addCustomEnvironmentVariable(@NotNull @NonNls String name, @NotNull File file2) {
        this.myCustomEnv.put(name, this.myExecutable.convertFilePath(file2));
    }

    public boolean containsCustomEnvironmentVariable(@NotNull @NonNls String key) {
        return this.myCustomEnv.containsKey(key);
    }

    public void setPreValidateExecutable(boolean preValidateExecutable) {
        this.myPreValidateExecutable = preValidateExecutable;
    }

    boolean isPreValidateExecutable() {
        return this.myPreValidateExecutable;
    }

    void runInCurrentThread() throws IOException {
        block7: {
            try {
                this.start();
                if (!this.isStarted()) break block7;
                try {
                    if (this.myInputProcessor != null) {
                        this.myInputProcessor.consume((Object)this.myProcess.getOutputStream());
                    }
                }
                finally {
                    this.waitForProcess();
                }
            }
            finally {
                this.logTime();
            }
        }
    }

    private void logTime() {
        if (this.myStartTime > 0L) {
            long time = System.currentTimeMillis() - this.myStartTime;
            if (!TIME_LOG.isDebugEnabled() && time > 10000L) {
                LOG.info(String.format("git %s took %s ms. Command parameters: %n%s", this.myCommand, time, this.myCommandLine.getCommandLineString()));
            } else {
                TIME_LOG.debug(String.format("git %s took %s ms", this.myCommand, time));
            }
        } else {
            LOG.debug(String.format("git %s finished.", this.myCommand));
        }
    }

    private void start() {
        if (this.myProject != null && !this.myProject.isDefault() && !TrustedProjects.isTrusted((Project)this.myProject)) {
            throw new IllegalStateException("Shouldn't be possible to run a Git command in the safe mode");
        }
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
        try {
            String logDirectoryPath;
            this.myStartTime = System.currentTimeMillis();
            String string = logDirectoryPath = this.myProject != null ? GitImplBase.stringifyWorkingDir(this.myProject.getBasePath(), this.myCommandLine.getWorkDirectory()) : this.myCommandLine.getWorkDirectory().getPath();
            if (!this.mySilent) {
                LOG.info("[" + logDirectoryPath + "] " + this.printableCommandLine());
            } else {
                LOG.debug("[" + logDirectoryPath + "] " + this.printableCommandLine());
            }
            this.prepareEnvironment();
            this.myExecutable.patchCommandLine(this, this.myCommandLine, this.myExecutableContext);
            OUTPUT_LOG.debug(String.format("%s %% %s started: %s", this.getCommand(), this.hashCode(), this.myCommandLine));
            this.myProcess = this.startProcess();
            this.startHandlingStreams();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(t);
            }
            ((ProcessEventListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    private void prepareEnvironment() {
        Map executionEnvironment = this.myCommandLine.getEnvironment();
        executionEnvironment.clear();
        if (this.myExecutable.isLocal()) {
            executionEnvironment.putAll(EnvironmentUtil.getEnvironmentMap());
        }
        executionEnvironment.putAll(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git"));
        executionEnvironment.putAll(this.myCustomEnv);
        if (!(ProgressManager.getInstance().getProgressIndicator() instanceof PotemkinProgress)) {
            VcsEnvCustomizer.EP_NAME.forEachExtensionSafe(customizer -> customizer.customizeCommandAndEnvironment(this.myProject, executionEnvironment, (VcsEnvCustomizer.VcsExecutableContext)this.myExecutableContext));
            executionEnvironment.remove("PS1");
        }
    }

    protected abstract Process startProcess() throws ExecutionException;

    protected abstract void startHandlingStreams();

    protected abstract void waitForProcess();

    public String toString() {
        return this.myCommandLine.toString();
    }

    @Deprecated(forRemoval=true)
    public boolean addProgressParameter() {
        if (this.myProject != null && GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(this.myProject)) {
            this.addParameters("--progress");
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public int getExitCode() {
        if (this.myExitCode == null) {
            return -1;
        }
        return this.myExitCode;
    }

    @Deprecated
    protected void setExitCode(int exitCode) {
        if (this.myExitCode == null) {
            this.myExitCode = exitCode;
        } else {
            LOG.info("Not setting exit code " + exitCode + ", because it was already set to " + this.myExitCode);
        }
    }

    @Deprecated
    public void addLastOutput(String line) {
        if (this.myLastOutput.size() < 5) {
            this.myLastOutput.add(line);
        } else {
            this.myLastOutput.add(0, line);
            Collections.rotate(this.myLastOutput, -1);
        }
    }

    @Deprecated
    public List<String> getLastOutput() {
        return this.myLastOutput;
    }

    @Deprecated
    void runInCurrentThread(@Nullable Runnable postStartAction) {
        try {
            this.start();
            if (this.isStarted()) {
                if (postStartAction != null) {
                    postStartAction.run();
                }
                this.waitForProcess();
            }
        }
        finally {
            this.logTime();
        }
    }

    @Deprecated
    abstract void destroyProcess();

    @Deprecated
    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    @Deprecated(forRemoval=true)
    public List<VcsException> errors() {
        return Collections.unmodifiableList(this.myErrors);
    }
}

