/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GitCommand {
    public static final GitCommand ADD = GitCommand.write("add");
    public static final GitCommand BLAME = GitCommand.read("blame");
    public static final GitCommand BRANCH = GitCommand.read("branch");
    public static final GitCommand CAT_FILE = GitCommand.read("cat-file");
    public static final GitCommand CHECKOUT = GitCommand.write("checkout");
    public static final GitCommand CHECK_ATTR = GitCommand.read("check-attr");
    public static final GitCommand CHECK_IGNORE = GitCommand.read("check-ignore");
    public static final GitCommand COMMIT = GitCommand.write("commit");
    public static final GitCommand CONFIG = GitCommand.read("config");
    public static final GitCommand CHERRY = GitCommand.read("cherry");
    public static final GitCommand CHERRY_PICK = GitCommand.write("cherry-pick");
    public static final GitCommand CLONE = GitCommand.read("clone");
    public static final GitCommand DIFF = GitCommand.read("diff");
    public static final GitCommand FETCH = GitCommand.read("fetch");
    public static final GitCommand INIT = GitCommand.write("init");
    public static final GitCommand LOG = GitCommand.read("log");
    public static final GitCommand SHORTLOG = GitCommand.read("shortlog");
    public static final GitCommand LS_FILES = GitCommand.readOptional("ls-files");
    public static final GitCommand LS_TREE = GitCommand.read("ls-tree");
    public static final GitCommand LS_REMOTE = GitCommand.read("ls-remote");
    public static final GitCommand MERGE = GitCommand.write("merge");
    public static final GitCommand MERGE_BASE = GitCommand.read("merge-base");
    public static final GitCommand MV = GitCommand.write("mv");
    public static final GitCommand PULL = GitCommand.write("pull");
    public static final GitCommand PUSH = GitCommand.write("push");
    public static final GitCommand REBASE = GitCommand.write("rebase");
    public static final GitCommand REMOTE = GitCommand.read("remote");
    public static final GitCommand RESET = GitCommand.write("reset");
    public static final GitCommand RESTORE = GitCommand.write("restore");
    public static final GitCommand REVERT = GitCommand.write("revert");
    public static final GitCommand REV_LIST = GitCommand.read("rev-list");
    public static final GitCommand REV_PARSE = GitCommand.read("rev-parse");
    public static final GitCommand RM = GitCommand.write("rm");
    public static final GitCommand SHOW = GitCommand.read("show");
    public static final GitCommand STASH = GitCommand.write("stash");
    public static final GitCommand STATUS = GitCommand.readOptional("status");
    public static final GitCommand SUBMODULE = GitCommand.write("submodule");
    public static final GitCommand SUBMODULE_HELPER = GitCommand.read("submodule--helper");
    public static final GitCommand TAG = GitCommand.read("tag");
    public static final GitCommand UPDATE_INDEX = GitCommand.write("update-index");
    public static final GitCommand UPDATE_REF = GitCommand.write("update-ref");
    public static final GitCommand HASH_OBJECT = GitCommand.write("hash-object");
    public static final GitCommand VERSION = GitCommand.read("version");
    @NonNls
    public static final String GIT_EDITOR_ENV = "GIT_EDITOR";
    @NonNls
    public static final String GIT_ASK_PASS_ENV = "GIT_ASKPASS";
    @NonNls
    public static final String GIT_SSH_ASK_PASS_ENV = "SSH_ASKPASS";
    @NonNls
    public static final String DISPLAY_ENV = "DISPLAY";
    @NotNull
    @NonNls
    private final String myName;
    @NotNull
    private final LockingPolicy myLocking;

    private GitCommand(@NotNull @NonNls String name, @NotNull LockingPolicy lockingPolicy) {
        this.myLocking = lockingPolicy;
        this.myName = name;
    }

    private GitCommand(@NotNull GitCommand command, @NotNull LockingPolicy lockingPolicy) {
        this.myName = command.name();
        this.myLocking = lockingPolicy;
    }

    @NotNull
    public GitCommand readLockingCommand() {
        return new GitCommand(this, LockingPolicy.READ);
    }

    @NotNull
    public GitCommand writeLockingCommand() {
        return new GitCommand(this, LockingPolicy.WRITE);
    }

    @NotNull
    private static GitCommand read(@NotNull @NonNls String name) {
        return new GitCommand(name, LockingPolicy.READ);
    }

    @NotNull
    private static GitCommand readOptional(@NotNull @NonNls String name) {
        return new GitCommand(name, LockingPolicy.READ_OPTIONAL_LOCKING);
    }

    @NotNull
    private static GitCommand write(@NotNull @NonNls String name) {
        return new GitCommand(name, LockingPolicy.WRITE);
    }

    @NotNull
    public String name() {
        return this.myName;
    }

    @NotNull
    public LockingPolicy lockingPolicy() {
        return this.myLocking;
    }

    public String toString() {
        return this.myName;
    }

    static enum LockingPolicy {
        READ,
        READ_OPTIONAL_LOCKING,
        WRITE;

    }
}

