/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerListener;
import git4idea.commands.GitImpl;
import git4idea.config.GitExecutable;
import git4idea.i18n.GitBundle;
import git4idea.util.GitVcsConsoleWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBinaryHandler
extends GitHandler {
    private static final int BUFFER_SIZE = 8192;
    @NotNull
    private final ByteArrayOutputStream myStdout = new ByteArrayOutputStream();
    @NotNull
    private final ByteArrayOutputStream myStderr = new ByteArrayOutputStream();
    @NotNull
    private final Semaphore mySteamSemaphore = new Semaphore(0);
    @NotNull
    private final AtomicReference<VcsException> myException = new AtomicReference();

    public GitBinaryHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        super(project, vcsRoot, command, Collections.emptyList());
    }

    public GitBinaryHandler(@NotNull File directory, @NotNull GitExecutable pathToExecutable, @NotNull GitCommand command) {
        super(null, directory, pathToExecutable, command, Collections.emptyList());
    }

    @Override
    protected Process startProcess() throws ExecutionException {
        return this.myCommandLine.createProcess();
    }

    @Override
    protected void startHandlingStreams() {
        this.handleStream(this.myProcess.getErrorStream(), this.myStderr, "Error stream copy of " + this.myCommandLine.getCommandLineString());
        this.handleStream(this.myProcess.getInputStream(), this.myStdout, "Output stream copy of " + this.myCommandLine.getCommandLineString());
    }

    private void handleStream(InputStream in, ByteArrayOutputStream out, @NotNull @NonNls String cmd) {
        Thread t = new Thread(() -> {
            try {
                int rc;
                byte[] buffer = new byte[8192];
                while ((rc = in.read(buffer)) != -1) {
                    out.write(buffer, 0, rc);
                }
            }
            catch (IOException e) {
                if (!this.myException.compareAndSet(null, new VcsException(GitBundle.message("git.error.cant.process.output", e.getLocalizedMessage()), (Throwable)e))) {
                    LOG.error("Problem reading stream", (Throwable)e);
                }
            }
            finally {
                this.mySteamSemaphore.release(1);
            }
        }, cmd);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void destroyProcess() {
        this.myProcess.destroy();
    }

    @Override
    protected void waitForProcess() {
        int exitCode;
        try {
            this.mySteamSemaphore.acquire(2);
            this.myProcess.waitFor();
            exitCode = this.myProcess.exitValue();
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring process exception: ", (Throwable)e);
            }
            exitCode = 255;
        }
        OUTPUT_LOG.debug(String.format("%s %% %s terminated (%s)", this.getCommand(), this.hashCode(), exitCode));
        this.setExitCode(exitCode);
        this.listeners().processTerminated(exitCode);
    }

    public byte @NotNull [] run() throws VcsException {
        Project project = this.project();
        final GitVcsConsoleWriter vcsConsoleWriter = project != null ? GitVcsConsoleWriter.getInstance(project) : null;
        this.addListener(new GitHandlerListener(){

            public void processTerminated(int exitCode) {
                if (exitCode != 0) {
                    VcsException e;
                    Charset cs = GitBinaryHandler.this.getCharset();
                    String message = new String(GitBinaryHandler.this.myStderr.toByteArray(), cs);
                    if (message.isEmpty()) {
                        message = GitBinaryHandler.this.myException.get() != null ? IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode}) : null;
                    } else if (vcsConsoleWriter != null && !GitBinaryHandler.this.isStderrSuppressed()) {
                        vcsConsoleWriter.showErrorMessage(message);
                    }
                    if (message != null && (e = GitBinaryHandler.this.myException.getAndSet(new VcsException(message))) != null) {
                        GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)e);
                    }
                }
            }

            public void startFailed(@NotNull Throwable exception) {
                VcsException err = new VcsException(GitBundle.message("git.executable.unknown.error.message", exception.getMessage()), exception);
                VcsException oldErr = GitBinaryHandler.this.myException.getAndSet(err);
                if (oldErr != null) {
                    GitHandler.LOG.warn("Dropping previous exception: ", (Throwable)oldErr);
                }
            }
        });
        if (vcsConsoleWriter != null && !this.mySilent) {
            vcsConsoleWriter.showCommandLine("[" + GitImpl.stringifyWorkingDir(project.getBasePath(), this.getWorkingDirectory()) + "] " + this.printableCommandLine());
        }
        try {
            this.runInCurrentThread();
        }
        catch (IOException e) {
            throw new VcsException(e.getMessage(), (Throwable)e);
        }
        if (this.myException.get() != null) {
            throw this.myException.get();
        }
        return this.myStdout.toByteArray();
    }
}

