/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitAbortOperationAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;

    public GitCherryPicker(@NotNull Project project) {
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    public void cherryPick(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        IntRef cherryPickedCommitsCount = new IntRef(1);
        new GitApplyChangesProcess(this.myProject, commits2, true, GitBundle.message("cherry.pick.name", new Object[0]), GitBundle.message("cherry.pick.applied", new Object[0]), (Function4<? super GitRepository, ? super VcsCommitMetadata, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit, autoCommit, listeners) -> {
            GitCommandResult result2 = this.cherryPickSingleCommit((GitRepository)repository, (VcsCommitMetadata)commit, (boolean)autoCommit, (List<? extends GitLineHandlerListener>)listeners, indicator, cherryPickedCommitsCount.get(), commits2.size());
            cherryPickedCommitsCount.inc();
            return result2;
        }), new GitAbortOperationAction.CherryPick(), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)((Function2)(repository, commit) -> this.createCommitMessage((GitRepository)repository, (VcsFullCommitDetails)commit)), true, (Function2<? super GitRepository, ? super Boolean, Unit>)((Function2)(repository, autoCommit) -> GitCherryPicker.cancelCherryPick(repository, autoCommit))).execute();
    }

    private GitCommandResult cherryPickSingleCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, boolean autoCommit, @NotNull List<? extends GitLineHandlerListener> listeners, @Nullable ProgressIndicator indicator, int alreadyCherryPickedCount, int totalCommitsToCherryPick) {
        if (indicator != null) {
            GitCherryPicker.updateCherryPickIndicatorText(indicator, commit, alreadyCherryPickedCount, totalCommitsToCherryPick);
        }
        GitCommandResult result2 = Git.getInstance().cherryPick(repository, ((Hash)commit.getId()).asString(), autoCommit, this.shouldAddSuffix(repository, (Hash)commit.getId()), listeners.toArray(new GitLineHandlerListener[0]));
        if (indicator != null) {
            indicator.setFraction((double)alreadyCherryPickedCount / (double)totalCommitsToCherryPick);
        }
        return result2;
    }

    private static void updateCherryPickIndicatorText(@NotNull ProgressIndicator indicator, @NotNull VcsCommitMetadata commit, int alreadyCherryPickedCount, int totalCommitsToCherryPick) {
        if (totalCommitsToCherryPick > 1) {
            indicator.setText(DvcsBundle.message((String)"cherry.picking.process.commit", (Object[])new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30), alreadyCherryPickedCount, totalCommitsToCherryPick}));
        } else {
            indicator.setText(DvcsBundle.message((String)"cherry.picking.process.commit.single", (Object[])new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30)}));
        }
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        String stdout = result2.getOutputAsJoinedString();
        return stdout.contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private String createCommitMessage(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit) {
        Object message = commit.getFullMessage();
        if (this.shouldAddSuffix(repository, (Hash)commit.getId())) {
            message = (String)message + String.format("\n\n(cherry picked from commit %s)", ((Hash)commit.getId()).asString());
        }
        return message;
    }

    private boolean shouldAddSuffix(@NotNull GitRepository repository, @NotNull Hash commit) {
        return this.mySettings.shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository, commit);
    }

    private static Unit cancelCherryPick(@NotNull GitRepository repository, boolean autoCommit) {
        if (autoCommit) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead();
        if (cherryPickHeadFile.exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getActionTitle() {
        return DvcsBundle.message((String)"cherry.pick.action.text", (Object[])new Object[0]);
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        return ContainerUtil.all(roots, r -> this.myRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }
}

