/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ModalityUiUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushAfterCommitDialog
extends VcsPushDialog {
    private JCheckBox myDontShowAgainCheckbox;

    public GitPushAfterCommitDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        super(project, selectedRepositories, currentRepo);
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        this.myDontShowAgainCheckbox = new JCheckBox(GitBundle.message("push.dialog.preview.commits.before.push", new Object[0]));
        this.myDontShowAgainCheckbox.setSelected(GitVcsSettings.getInstance(this.myProject).shouldPreviewPushOnCommitAndPush());
        JPanel basePanel = super.createOptionsPanel();
        if (PushUtils.getProhibitedTarget((VcsPushUi)this) != null) {
            return basePanel;
        }
        basePanel.add(this.myDontShowAgainCheckbox);
        return basePanel;
    }

    public void push(boolean forcePush) {
        GitVcsSettings settings;
        if (!this.myDontShowAgainCheckbox.isSelected() && (settings = GitVcsSettings.getInstance(this.myProject)).shouldPreviewPushOnCommitAndPush()) {
            settings.setPreviewPushProtectedOnly(true);
        }
        super.push(forcePush);
    }

    public void showOrPush() {
        boolean hasProtectedBranch = PushUtils.getProhibitedTarget((VcsPushUi)this) != null;
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(this.myProject);
        boolean showDialog = vcsSettings.shouldPreviewPushOnCommitAndPush();
        boolean showOnlyProtected = vcsSettings.isPreviewPushProtectedOnly();
        if (showDialog && (!showOnlyProtected || hasProtectedBranch) || !this.canPush()) {
            this.show();
        } else {
            this.push(false);
        }
    }

    public static void showOrPush(@NotNull Project project, @NotNull Collection<GitRepository> selectedRepositories) {
        ModalityState modality = ModalityState.defaultModalityState();
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(selectedRepositories);
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)modality, (Condition)project.getDisposed(), () -> {
            GitRepository selectedRepo = (GitRepository)DvcsUtil.guessRepositoryForOperation((Project)project, (AbstractRepositoryManager)GitRepositoryManager.getInstance(project));
            new GitPushAfterCommitDialog(project, repositories, selectedRepo).showOrPush();
        });
    }
}

