/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.PostCommitChangeConverter;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.log.Hash;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter;", "Lcom/intellij/openapi/vcs/checkin/PostCommitChangeConverter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "convertChangeAfterCommit", "Lcom/intellij/openapi/vcs/changes/Change;", "change", "hashes", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/Hash;", "convertChangesAfterCommit", "", "changes", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "Companion", "intellij.vcs.git"})
public final class GitPostCommitChangeConverter
implements PostCommitChangeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<Map<GitRepository, Hash>> GIT_POST_COMMIT_HASHES_KEY;
    @NotNull
    private static final ReadWriteProperty<? super CommitContext, Map<GitRepository, Hash>> postCommitHashes$delegate;

    public GitPostCommitChangeConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Change> convertChangesAfterCommit(@NotNull List<? extends Change> changes, @NotNull CommitContext commitContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        Map map2 = GitPostCommitChangeConverter.Companion.getPostCommitHashes(commitContext);
        if (map2 == null) {
            return changes;
        }
        Map hashes2 = map2;
        Iterable $this$map$iv = changes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Change change = (Change)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Change change2 = this.convertChangeAfterCommit((Change)it, hashes2);
            if (change2 == null) {
                change2 = it;
            }
            collection.add(change2);
        }
        return (List)destination$iv$iv;
    }

    private final Change convertChangeAfterCommit(Change change, Map<GitRepository, ? extends Hash> hashes2) {
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(change)");
        FilePath filePath2 = filePath;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFile(filePath2);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        Hash hash = hashes2.get(repository);
        if (hash == null) {
            return null;
        }
        Hash commitHash = hash;
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision contentRevision = bRev;
        ContentRevision fixedBRev = contentRevision != null ? GitContentRevision.createRevision(contentRevision.getFile(), (VcsRevisionNumber)new GitRevisionNumber(commitHash.asString() + "~1"), this.project) : null;
        ContentRevision aRev = change.getAfterRevision();
        ContentRevision contentRevision2 = aRev;
        ContentRevision fixedARev = contentRevision2 != null ? GitContentRevision.createRevision(contentRevision2.getFile(), (VcsRevisionNumber)new GitRevisionNumber(commitHash.asString()), this.project) : null;
        return new Change(fixedBRev, fixedARev, change.getFileStatus());
    }

    @JvmStatic
    public static final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository) {
        Companion.markRepositoryCommit(commitContext, repository);
    }

    static {
        Key key = Key.create((String)"Git.Post.Commit.Hash");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<MutableMap<GitRep\u2026>(\"Git.Post.Commit.Hash\")");
        GIT_POST_COMMIT_HASHES_KEY = key;
        postCommitHashes$delegate = AbstractCommitWorkflowKt.commitProperty(GIT_POST_COMMIT_HASHES_KEY, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0007R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RK\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\f2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00058B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitPostCommitChangeConverter$Companion;", "", "()V", "GIT_POST_COMMIT_HASHES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/Hash;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "postCommitHashes", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "getPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", "setPostCommitHashes", "(Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/util/Map;)V", "postCommitHashes$delegate", "Lkotlin/properties/ReadWriteProperty;", "markRepositoryCommit", "", "commitContext", "repository", "intellij.vcs.git"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Map<GitRepository, Hash> getPostCommitHashes(CommitContext $this$postCommitHashes) {
            return (Map)postCommitHashes$delegate.getValue((Object)$this$postCommitHashes, $$delegatedProperties[0]);
        }

        private final void setPostCommitHashes(CommitContext $this$postCommitHashes, Map<GitRepository, Hash> map2) {
            postCommitHashes$delegate.setValue((Object)$this$postCommitHashes, $$delegatedProperties[0], map2);
        }

        @JvmStatic
        public final void markRepositoryCommit(@NotNull CommitContext commitContext, @NotNull GitRepository repository) {
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Map hashes2 = this.getPostCommitHashes(commitContext);
            if (hashes2 == null) {
                hashes2 = new LinkedHashMap();
                this.setPostCommitHashes(commitContext, hashes2);
            }
            Hash hash = GitUtil.getHead(repository);
            if (hash == null) {
                return;
            }
            Hash head = hash;
            Hash oldHead = hashes2.put(repository, head);
            if (oldHead != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitPostCommitChangeConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Multiple commits found for " + repository + ": " + head + " - " + oldHead);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "postCommitHashes", "getPostCommitHashes(Lcom/intellij/openapi/vcs/changes/CommitContext;)Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

