/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.checkin.GitCheckinHandler;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler;", "Lgit4idea/checkin/GitCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getDetachedRoot", "Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DetachedRoot", "GitDetachedRootCommitProblem", "intellij.vcs.git"})
final class GitDetachedRootCheckinHandler
extends GitCheckinHandler {
    public GitDetachedRootCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return GitVcsSettings.getInstance(this.getProject()).warnAboutDetachedHead();
    }

    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        DetachedRoot detachedRoot = this.getDetachedRoot(commitInfo);
        if (detachedRoot == null) {
            return null;
        }
        HtmlChunk.Element element = HtmlChunk.text((String)detachedRoot.getRoot().getPresentableUrl()).bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(detachedRoot.root.presentableUrl).bold()");
        HtmlChunk.Element rootPath = element;
        String title = null;
        HtmlBuilder message = new HtmlBuilder();
        if (detachedRoot.isDuringRebase()) {
            String string = GitBundle.message("warning.title.commit.with.unfinished.rebase", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"warning.title.c\u2026.with.unfinished.rebase\")");
            title = string;
            var7_7 = new Object[]{rootPath.toString()};
            message.appendRaw(GitBundle.message("warning.message.commit.with.unfinished.rebase", var7_7)).br().appendLink("https://git-scm.com/docs/git-rebase", GitBundle.message("link.label.commit.with.unfinished.rebase.read.more", new Object[0]));
        } else {
            String string = GitBundle.message("warning.title.commit.with.detached.head", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"warning.title.commit.with.detached.head\")");
            title = string;
            var7_7 = new Object[]{rootPath.toString()};
            message.appendRaw(GitBundle.message("warning.message.commit.with.detached.head", var7_7)).br().appendLink("https://git-scm.com/docs/git-checkout#_detached_head", GitBundle.message("link.label.commit.with.detached.head.read.more", new Object[0]));
        }
        DoNotAskOption dontAskAgain2 = (DoNotAskOption)new DoNotAskOption.Adapter(this){
            final /* synthetic */ GitDetachedRootCheckinHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                GitVcsSettings.getInstance(this.this$0.getProject()).setWarnAboutDetachedHead(!isSelected);
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = GitBundle.message("checkbox.dont.warn.again", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkbox.dont.warn.again\")");
                return string;
            }
        };
        String string = message.wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.wrapWithHtmlBody().toString()");
        boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).doNotAsk(dontAskAgain2)).ask(this.getProject());
        if (commit) {
            return null;
        }
        return new GitDetachedRootCommitProblem();
    }

    private final DetachedRoot getDetachedRoot(CommitInfo commitInfo) {
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(project)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile root : this.getSelectedRoots(commitInfo)) {
            GitRepository repository;
            if ((GitRepository)repositoryManager.getRepositoryForRootQuick(root) == null || repository.isOnBranch() || GitRebaseUtils.isInteractiveRebaseInProgress(repository)) continue;
            return new DetachedRoot(root, repository.isRebaseInProgress());
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$GitDetachedRootCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "()V", "text", "", "getText", "()Ljava/lang/String;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "project", "Lcom/intellij/openapi/project/Project;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.vcs.git"})
    private static final class GitDetachedRootCommitProblem
    implements CommitProblem {
        @NotNull
        public String getText() {
            String string = GitBundle.message("commit.check.warning.title.commit.with.detached.head", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"commit.check.wa\u2026mmit.with.detached.head\")");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDuringRebase", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Z", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
    private static final class DetachedRoot {
        @NotNull
        private final VirtualFile root;
        private final boolean isDuringRebase;

        public DetachedRoot(@NotNull VirtualFile root, boolean isDuringRebase) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
            this.isDuringRebase = isDuringRebase;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        public final boolean isDuringRebase() {
            return this.isDuringRebase;
        }
    }
}

