/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.BranchRenameListener;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitRenameBranchOperation
extends GitBranchOperation {
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    @NlsSafe
    private final String myCurrentName;
    @NotNull
    @NlsSafe
    private final String myNewName;

    GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull @NlsSafe String currentName, @NotNull @NlsSafe String newName, @NotNull List<? extends GitRepository> repositories) {
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.renameBranch(repository, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.update();
                this.notifyBranchNameChanged(repository, this.myCurrentName, this.myNewName);
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("git.rename.branch.could.not.rename.from.to", this.myCurrentName, this.myNewName), result2);
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            GitCommandResult result2 = this.myGit.renameBranch(repository, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.update();
                this.notifyBranchNameChanged(repository, this.myNewName, this.myCurrentName);
            }
            compoundResult.append(repository, result2);
        }
        if (compoundResult.totalSuccess()) {
            this.myNotifier.notifySuccess("git.branch.rename.rollback.success", GitBundle.message("git.rename.branch.rollback.successful", new Object[0]), GitBundle.message("git.rename.branch.renamed.back.to", this.myCurrentName));
        } else {
            this.myNotifier.notifyError("git.branch.rename.rollback.failed", GitBundle.message("git.rename.branch.rollback.failed", new Object[0]), compoundResult.getErrorOutputWithReposIndication(), true);
        }
    }

    protected final void notifyBranchNameChanged(@NotNull GitRepository repository, @NotNull String oldName, @NotNull String newName) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((BranchRenameListener)this.myProject.getMessageBus().syncPublisher(BranchRenameListener.VCS_BRANCH_RENAMED)).branchNameChanged(repository.getRoot(), oldName, newName);
        });
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        return GitBundle.message("git.rename.branch.was.renamed.to", HtmlChunk.text((String)this.myCurrentName).code().bold(), HtmlChunk.text((String)this.myNewName).code().bold());
    }

    @Override
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getRollbackProposal() {
        return new HtmlBuilder().append(GitBundle.message("git.rename.branch.has.succeeded.for.the.following.repositories", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("git.rename.branch.you.may.rename.branch.back", this.myCurrentName)).toString();
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        return GitBundle.message("rename.branch.operation.name", new Object[0]);
    }
}

