/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitDeleteRemoteTagOperation
extends GitBranchOperation {
    @NotNull
    private final Map<GitRepository, String> myRepositories;
    private final String myTagName;

    GitDeleteRemoteTagOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull Map<GitRepository, String> repositories, @NotNull String name) {
        super(project, git, handler, repositories.keySet());
        this.myRepositories = repositories;
        this.myTagName = name;
    }

    @Override
    protected void execute() {
        int remotesCount;
        String tagFullName = "refs/tags/" + this.myTagName;
        int successRemotes = 0;
        int failureRemotes = 0;
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getRepositories();
        for (GitRepository repository : repositories) {
            String expectedCommit = this.myRepositories.get(repository);
            List<GitPushParams.ForceWithLease> forceWithLease = expectedCommit != null ? Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(tagFullName, expectedCommit)) : Collections.emptyList();
            for (GitRemote remote : repository.getRemotes()) {
                GitCommandResult lsRemoteResult = this.myGit.lsRemoteRefs(this.myProject, repository.getRoot(), remote, Collections.singletonList(tagFullName), "--tags");
                if (!lsRemoteResult.success()) {
                    result2.append(repository, lsRemoteResult);
                    continue;
                }
                if (!GitDeleteRemoteTagOperation.hasTagOnRemote(tagFullName, lsRemoteResult.getOutput())) continue;
                GitCommandResult pushResult = this.myGit.push(repository, new GitPushParamsImpl(remote, ":" + tagFullName, false, false, false, null, forceWithLease), new GitLineHandlerListener[0]);
                result2.append(repository, pushResult);
                if (pushResult.success()) {
                    ++successRemotes;
                    continue;
                }
                ++failureRemotes;
            }
            repository.update();
        }
        int n = remotesCount = ContainerUtil.exists(repositories, it -> it.getRemotes().size() > 1) ? 1 : 2;
        if (successRemotes > 0) {
            message = GitBundle.message("delete.remote.tag.operation.deleted.tag.on.remotes", remotesCount, this.myTagName);
            this.notifySuccessWithEmptyTitle(message);
        } else if (successRemotes == 0 && failureRemotes == 0) {
            message = GitBundle.message("delete.remote.tag.operation.tag.does.not.exist.on.remotes", remotesCount, this.myTagName);
            this.notifySuccessWithEmptyTitle(message);
        }
        if (!result2.totalSuccess()) {
            String title = GitBundle.message("delete.remote.tag.operation.failed.to.delete.tag.on.remotes", this.myTagName, remotesCount);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.tag.remote.deletion.error", title, result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private static boolean hasTagOnRemote(@NotNull String tagFullName, @NotNull List<String> lsRemoteOutput) {
        return ContainerUtil.exists(lsRemoteOutput, line -> {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return false;
            }
            List split = StringUtil.split((String)line, (String)"\t");
            if (split.size() != 2) {
                return false;
            }
            return tagFullName.equals(split.get(1));
        });
    }

    private void notifySuccessWithEmptyTitle(@NotNull @NlsContexts.NotificationContent String message) {
        Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(message, NotificationType.INFORMATION);
        notification2.setDisplayId("git.tag.remote.deletion.success");
        VcsNotifier.getInstance((Project)this.myProject).notify(notification2);
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }
}

