/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitCheckoutNewBranchOperation
extends GitBranchOperation {
    @NotNull
    private final String myNewBranchName;

    GitCheckoutNewBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String newBranchName) {
        super(project, git, uiHandler, repositories);
        this.myNewBranchName = newBranchName;
    }

    @Override
    protected void execute() {
        boolean fatalErrorHappened = false;
        this.notifyBranchWillChange();
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitSimpleEventDetector unmergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.checkoutNewBranch(repository, this.myNewBranchName, unmergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT));
            if (result2.success()) {
                GitCheckoutNewBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (unmergedDetector.hasHappened()) {
                this.fatalUnmergedFilesError();
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(GitBundle.message("checkout.new.branch.operation.could.not.create.new.branch", this.myNewBranchName), result2);
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.notifyBranchHasChanged(this.myNewBranchName);
            this.updateRecentBranch();
        }
    }

    private static void refresh(@NotNull GitRepository repository) {
        repository.update();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        return GitBundle.message("checkout.new.branch.operation.branch.was.created", GitUIUtil.bold(GitUIUtil.code(this.myNewBranchName)));
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return new HtmlBuilder().append(GitBundle.message("checkout.new.branch.operation.however.checkout.has.succeeded.for.the.following", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("checkout.new.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.myNewBranchName)).toString();
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        return GitBundle.message("checkout.operation.name", new Object[0]);
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            GitCommandResult result2 = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result2);
            if (result2.success()) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranchName, false, new GitLineHandlerListener[0]));
            }
            GitCheckoutNewBranchOperation.refresh(repository);
        }
        if (checkoutResult.totalSuccess() && deleteResult.totalSuccess()) {
            message = GitBundle.message("checkout.new.branch.operation.checked.out.0.and.deleted.1.on.2.3", GitCheckoutNewBranchOperation.stringifyBranchesByRepos(this.myCurrentHeads), GitUIUtil.code(this.myNewBranchName), repositories.size(), this.successfulRepositoriesJoined());
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.checkout.new.branch.operation.rollback.successful", GitBundle.message("checkout.new.branch.operation.rollback.successful", new Object[0]), (String)message);
        } else {
            message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.new.branch.operation.errors.during.checkout", new Object[0]));
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.new.branch.operation.errors.during.deleting", GitUIUtil.code(this.myNewBranchName)));
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.checkout.new.branch.operation.rollback.error", GitBundle.message("checkout.new.branch.operation.error.during.rollback", new Object[0]), message.toString(), true);
        }
    }
}

