/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandler;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GitBranchOperation {
    protected static final Logger LOG = Logger.getInstance(GitBranchOperation.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final GitBranchUiHandler myUiHandler;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    protected final Map<GitRepository, String> myCurrentHeads;
    @NotNull
    protected final Map<GitRepository, String> myInitialRevisions;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final Collection<GitRepository> mySuccessfulRepositories;
    @NotNull
    private final Collection<GitRepository> mySkippedRepositories;
    @NotNull
    private final Collection<GitRepository> myRemainingRepositories;

    protected GitBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories) {
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myRepositories = GitUtil.getRepositoryManager(project).sortByDependency(repositories);
        this.myCurrentHeads = ContainerUtil.newMapFromKeys(repositories.iterator(), repo -> (String)ObjectUtils.chooseNotNull((Object)repo.getCurrentBranchName(), (Object)repo.getCurrentRevision()));
        this.myInitialRevisions = ContainerUtil.newMapFromKeys(repositories.iterator(), Repository::getCurrentRevision);
        this.mySuccessfulRepositories = new ArrayList<GitRepository>();
        this.mySkippedRepositories = new ArrayList<GitRepository>();
        this.myRemainingRepositories = new ArrayList<GitRepository>(this.myRepositories);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    protected abstract void execute();

    protected abstract void rollback();

    @NotNull
    @NlsContexts.NotificationContent
    protected abstract String getSuccessMessage();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected abstract String getRollbackProposal();

    @NotNull
    @Nls
    protected abstract String getOperationName();

    @NotNull
    protected final GitRepository next() {
        return this.myRemainingRepositories.iterator().next();
    }

    protected final boolean hasMoreRepositories() {
        return !this.myRemainingRepositories.isEmpty();
    }

    protected final void markSuccessful(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySuccessfulRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected final void markSkip(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySkippedRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected final boolean wereSuccessful() {
        return !this.mySuccessfulRepositories.isEmpty();
    }

    protected final boolean wereSkipped() {
        return !this.mySkippedRepositories.isEmpty();
    }

    @NotNull
    protected final Collection<GitRepository> getSuccessfulRepositories() {
        return this.mySuccessfulRepositories;
    }

    @NotNull
    protected final Collection<GitRepository> getSkippedRepositories() {
        return this.mySkippedRepositories;
    }

    @NotNull
    @NlsSafe
    protected final String successfulRepositoriesJoined() {
        return GitUtil.joinToHtml(this.mySuccessfulRepositories);
    }

    @NotNull
    protected final Collection<GitRepository> getRepositories() {
        return this.myRepositories;
    }

    @NotNull
    protected final List<GitRepository> getRemainingRepositoriesExceptGiven(@NotNull GitRepository currentRepository) {
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(this.myRemainingRepositories);
        repositories.remove(currentRepository);
        return repositories;
    }

    protected void notifySuccess(@NotNull @NlsContexts.NotificationContent String message) {
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.branch.operation.success", "", message);
    }

    protected void notifySuccess() {
        this.notifySuccess(this.getSuccessMessage());
    }

    protected static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    protected final void fatalError(@NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String message) {
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, message);
        } else {
            this.notifyError(title, message);
        }
    }

    protected final void fatalError(@NotNull @NlsContexts.NotificationTitle String title, @NotNull GitCommandResult result2) {
        this.fatalError(title, result2.getErrorOutputAsHtmlString());
    }

    protected final void showFatalErrorDialogWithRollback(@NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.DialogMessage String message) {
        boolean rollback = this.myUiHandler.notifyErrorWithRollbackProposal(title, message, this.getRollbackProposal());
        if (rollback) {
            this.rollback();
        }
    }

    protected final void notifyError(@NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String message) {
        this.myUiHandler.notifyError(title, message);
    }

    @NotNull
    protected final ProgressIndicator getIndicator() {
        return this.myUiHandler.getProgressIndicator();
    }

    protected final void fatalUnmergedFilesError() {
        if (this.wereSuccessful()) {
            this.showUnmergedFilesDialogWithRollback();
        } else {
            this.showUnmergedFilesNotification();
        }
    }

    protected final void updateRecentBranch() {
        if (this.getRepositories().size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            String currentHead = this.myCurrentHeads.get(repository);
            if (currentHead != null) {
                this.mySettings.setRecentBranchOfRepository(repository.getRoot().getPath(), currentHead);
            } else {
                LOG.error("Current head is not known for " + repository.getRoot().getPath());
            }
        } else {
            String recentCommonBranch = this.getRecentCommonBranch();
            if (recentCommonBranch != null) {
                this.mySettings.setRecentCommonBranch(recentCommonBranch);
            }
        }
    }

    protected final void notifyBranchWillChange() {
        String currentBranch = (String)ContainerUtil.getFirstItem(this.myCurrentHeads.values());
        if (currentBranch != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchWillChange(currentBranch);
            });
        }
    }

    protected final void notifyBranchHasChanged(@Nullable String branchName) {
        if (branchName != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((BranchChangeListener)this.myProject.getMessageBus().syncPublisher(BranchChangeListener.VCS_BRANCH_CHANGED)).branchHasChanged(branchName);
            });
        }
    }

    @NotNull
    protected final String getInitialRevision(@NotNull GitRepository repository) {
        return this.myInitialRevisions.get(repository);
    }

    @Nullable
    private String getRecentCommonBranch() {
        String recentCommonBranch = null;
        for (String branch : this.myCurrentHeads.values()) {
            if (recentCommonBranch == null) {
                recentCommonBranch = branch;
                continue;
            }
            if (recentCommonBranch.equals(branch)) continue;
            return null;
        }
        return recentCommonBranch;
    }

    private void showUnmergedFilesDialogWithRollback() {
        boolean ok = this.myUiHandler.showUnmergedFilesMessageWithRollback(this.getOperationName(), this.getRollbackProposal());
        if (ok) {
            this.rollback();
        }
    }

    private void showUnmergedFilesNotification() {
        this.myUiHandler.showUnmergedFilesNotification(this.getOperationName(), this.getRepositories());
    }

    protected final void fatalLocalChangesError(@NotNull String reference) {
        String title = GitBundle.message("branch.operation.could.not.0.operation.name.1.reference", this.getOperationName(), reference);
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, "");
        }
    }

    protected final void fatalUntrackedFilesError(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        String operationName = this.getOperationName();
        if (this.wereSuccessful()) {
            boolean ok = this.myUiHandler.showUntrackedFilesDialogWithRollback(operationName, this.getRollbackProposal(), root, relativePaths);
            if (ok) {
                this.rollback();
            }
        } else {
            this.myUiHandler.showUntrackedFilesNotification(operationName, root, relativePaths);
        }
    }

    @NotNull
    private Map<GitRepository, List<Change>> collectLocalChangesConflictingWithBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String otherBranch) {
        HashMap<GitRepository, List<Change>> changes = new HashMap<GitRepository, List<Change>>();
        for (GitRepository gitRepository : repositories) {
            Collection<Change> diffWithWorkingTree = GitChangeUtils.getDiffWithWorkingTree(gitRepository, otherBranch, false);
            if (diffWithWorkingTree == null) continue;
            List diff = ChangesUtil.iteratePaths(diffWithWorkingTree).map(FilePath::getPath).toList();
            List<Change> changesInRepo = GitUtil.findLocalChangesForPaths(this.myProject, gitRepository.getRoot(), diff, false);
            if (changesInRepo.isEmpty()) continue;
            changes.put(gitRepository, changesInRepo);
        }
        return changes;
    }

    @NotNull
    protected final Pair<List<GitRepository>, List<Change>> getConflictingRepositoriesAndAffectedChanges(@NotNull GitRepository currentRepository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenBy, String currentBranch, String nextBranch) {
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, currentRepository.getRoot(), localChangesOverwrittenBy.getRelativeFilePaths(), true);
        Map<GitRepository, List<Change>> conflictingChangesInRepositories = this.collectLocalChangesConflictingWithBranch(this.getRemainingRepositoriesExceptGiven(currentRepository), nextBranch);
        Set<GitRepository> otherProblematicRepositories = conflictingChangesInRepositories.keySet();
        ArrayList<GitRepository> allConflictingRepositories = new ArrayList<GitRepository>(otherProblematicRepositories);
        allConflictingRepositories.add(currentRepository);
        for (List<Change> changes : conflictingChangesInRepositories.values()) {
            affectedChanges.addAll(changes);
        }
        return Pair.create(allConflictingRepositories, affectedChanges);
    }

    @NotNull
    protected static String stringifyBranchesByRepos(@NotNull Map<GitRepository, String> heads) {
        MultiMap<String, VirtualFile> grouped = GitBranchOperation.groupByBranches(heads);
        if (grouped.size() == 1) {
            return (String)grouped.keySet().iterator().next();
        }
        return StringUtil.join((Collection)grouped.entrySet(), entry -> {
            String roots = StringUtil.join((Collection)((Collection)entry.getValue()), file2 -> file2.getName(), (String)", ");
            return GitBundle.message("branch.operation.in", entry.getKey(), roots);
        }, (String)"<br/>");
    }

    @NotNull
    private static MultiMap<String, VirtualFile> groupByBranches(@NotNull Map<GitRepository, String> heads) {
        MultiMap result2 = MultiMap.createLinked();
        List sortedRepos = DvcsUtil.sortRepositories(heads.keySet());
        for (GitRepository repo : sortedRepos) {
            result2.putValue((Object)heads.get(repo), (Object)repo.getRoot());
        }
        return result2;
    }
}

