/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import git4idea.branch.DeepComparator;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, dataProvider, (VcsLogUi)ui).hasHighlightingOrInProgress();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        MainVcsLogUi ui = (MainVcsLogUi)e.getData(VcsLogInternalDataKeys.MAIN_UI);
        VcsLogData dataProvider = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (project == null || dataProvider == null || ui == null) {
            return;
        }
        DeepComparator dc = DeepComparator.getInstance(project, dataProvider, (VcsLogUi)ui);
        if (selected) {
            VcsLogUsageTriggerCollector.triggerUsage((AnActionEvent)e, (Object)((Object)this));
            VisiblePack dataPack = ui.getDataPack();
            String singleBranchName = DeepComparator.getComparedBranchFromFilters(ui.getFilterUi().getFilters(), dataPack.getRefs());
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction((VcsLogUiEx)ui, e, (Consumer<? super String>)((Consumer)arg_0 -> DeepCompareAction.lambda$setSelected$0(ui, dc, (VcsLogDataPack)dataPack, arg_0)), DeepCompareAction.getGitRoots(project, (VcsLogUi)ui));
                return;
            }
            dc.startTask((VcsLogDataPack)dataPack, singleBranchName);
        } else {
            dc.stopTaskAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogUiEx ui, @NotNull AnActionEvent event, final @NotNull Consumer<? super String> consumer2, @NotNull Collection<? extends VirtualFile> visibleRoots) {
        VisiblePack dataPack = ui.getDataPack();
        ActionGroup actionGroup = new BranchPopupBuilder((VcsLogDataPack)dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull @NlsActions.ActionText String name, @NotNull Collection<? extends VcsRef> refs) {
                return new DumbAwareAction(name){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        consumer2.consume((Object)name);
                    }
                };
            }
        }.build();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(GitBundle.message("git.log.cherry.picked.highlighter.select.branch.popup", new Object[0]), actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup2.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup2.showInCenterOf((Component)ui.getTable());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            Set visibleRoots = VcsLogUtil.getVisibleRoots((VcsLogUi)ui);
            Set allRoots = visibleRoots;
            if (allRoots.isEmpty()) {
                allRoots = ContainerUtil.map2Set((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots(), VcsRoot::getPath);
            }
            e.getPresentation().setEnabled(DeepCompareAction.hasGitRoots(project, visibleRoots));
            e.getPresentation().setVisible(DeepCompareAction.hasGitRoots(project, allRoots));
        }
    }

    @NotNull
    private static Collection<VirtualFile> getGitRoots(@NotNull Project project, @NotNull VcsLogUi ui) {
        return ContainerUtil.filter((Collection)VcsLogUtil.getVisibleRoots((VcsLogUi)ui), root -> DeepCompareAction.isGitRoot(project, root));
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots) {
        return ContainerUtil.exists(roots, root -> DeepCompareAction.isGitRoot(project, root));
    }

    private static boolean isGitRoot(@NotNull Project project, @NotNull VirtualFile root) {
        return GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root) != null;
    }

    private static /* synthetic */ void lambda$setSelected$0(MainVcsLogUi ui, DeepComparator dc, VcsLogDataPack dataPack, String selectedBranch) {
        VcsLogFilterCollection collection = ui.getFilterUi().getFilters();
        collection = VcsLogFiltersKt.without((VcsLogFilterCollection)collection, VcsLogBranchLikeFilter.class);
        collection = VcsLogFiltersKt.with((VcsLogFilterCollection)collection, (VcsLogFilter)VcsLogFilterObject.fromBranch((String)selectedBranch));
        ui.getFilterUi().setFilters(collection);
        dc.startTask(dataPack, selectedBranch);
    }
}

