/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitCheckoutAndRebaseRemoteBranchWorkflow;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0014H\u0002J.\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lgit4idea/actions/branch/GitCheckoutWithRebaseAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "()V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "askBranchName", "Lgit4idea/branch/GitNewBranchOptions;", "Lgit4idea/GitRemoteBranch;", "suggestedLocalName", "", "checkoutAndRebaseRemote", "updateIfEnabledAndVisible", "intellij.vcs.git"})
public final class GitCheckoutWithRebaseAction
extends GitSingleBranchAction {
    private final boolean disabledForCurrent;

    public GitCheckoutWithRebaseAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"branches\u2026and.rebase.onto.current\")");
        super(supplier);
        this.disabledForCurrent = true;
    }

    @Override
    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories), branch.getName()};
        String string = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"branches.checko\u2026             branch.name)");
        String description2 = string;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories)};
        presentation2.setText(GitBundle.message("branches.checkout.and.rebase.onto.branch", objectArray));
        presentation2.setDescription(description2);
        GitBranchPopupActions.addTooltipText(presentation2, description2);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (branch instanceof GitRemoteBranch) {
            this.checkoutAndRebaseRemote(project, repositories, (GitRemoteBranch)branch);
        } else {
            GitBrancher.getInstance(project).rebaseOnCurrent(repositories, branch.getName());
        }
    }

    private final void checkoutAndRebaseRemote(Project project, List<? extends GitRepository> repositories, GitRemoteBranch branch) {
        String string = branch.getNameForRemoteOperations();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"branch.nameForRemoteOperations");
        String suggestedLocalName = string;
        GitNewBranchOptions newBranchOptions = new GitNewBranchOptions(suggestedLocalName, false, true, false, 8, null);
        if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getName(), (Object)suggestedLocalName)) {
            newBranchOptions = this.askBranchName(project, repositories, branch, suggestedLocalName);
        }
        if (newBranchOptions == null) {
            return;
        }
        String localName = newBranchOptions.getName();
        Map map2 = ContainerUtil.map2MapNotNull((Collection)repositories, arg_0 -> GitCheckoutWithRebaseAction.checkoutAndRebaseRemote$lambda$0((Function1)new Function1<GitRepository, Pair<? extends GitRepository, ? extends GitLocalBranch>>(localName){
            final /* synthetic */ String $localName;
            {
                this.$localName = $localName;
                super(1);
            }

            public final Pair<? extends GitRepository, ? extends GitLocalBranch> invoke(@NotNull GitRepository r) {
                GitLocalBranch local;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                GitLocalBranch gitLocalBranch = local = r.getBranches().findLocalBranch(this.$localName);
                return gitLocalBranch != null ? Pair.create((Object)r, (Object)gitLocalBranch) : null;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"localName = newBranchOpt\u2026r, local) else null\n    }");
        Map conflictingLocalBranches2 = map2;
        String string2 = branch.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"branch.name");
        if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches2, string2)) {
            newBranchOptions = this.askBranchName(project, repositories, branch, localName);
        }
        if (newBranchOptions == null) {
            return;
        }
        GitCheckoutAndRebaseRemoteBranchWorkflow workflow = new GitCheckoutAndRebaseRemoteBranchWorkflow(project, repositories);
        String string3 = branch.getNameForLocalOperations();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"branch.nameForLocalOperations");
        workflow.execute(string3, newBranchOptions);
    }

    private final GitNewBranchOptions askBranchName(Project project, List<? extends GitRepository> repositories, GitRemoteBranch branch, String suggestedLocalName) {
        Collection collection = repositories;
        Object[] objectArray = new Object[]{branch.getName()};
        String string = GitBundle.message("branches.checkout.s", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"branches.checkout.s\", branch.name)");
        return new GitNewBranchDialog(project, collection, string, suggestedLocalName, false, true, false, false, null, 448, null).showAndGetOptions();
    }

    private static final Pair checkoutAndRebaseRemote$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }
}

