/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitToggleAnnotationOptionsActionProvider
implements AnnotationGutterActionProvider {
    private static final GitVcsApplicationSettings SETTINGS = GitVcsApplicationSettings.getInstance();

    @NotNull
    public AnAction createAction(@NotNull FileAnnotation annotation) {
        return new MyGroup(annotation);
    }

    public static void resetAllAnnotations(@NotNull Project project, boolean clearCaches) {
        if (clearCaches) {
            ProjectLevelVcsManager.getInstance((Project)project).getVcsHistoryCache().clearAnnotations();
        }
        ProjectLevelVcsManager.getInstance((Project)project).getAnnotationLocalChangesListener().reloadAnnotationsForVcs(GitVcs.getKey());
    }

    private static class MyGroup
    extends ActionGroup
    implements ActionUpdateThreadAware.Recursive {
        private final FileAnnotation myAnnotation;

        MyGroup(@NotNull FileAnnotation annotation) {
            super(GitBundle.message("annotations.options.group", new Object[0]), true);
            this.myAnnotation = annotation;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myAnnotation instanceof GitFileAnnotation) {
                return new AnAction[]{new ToggleIgnoreWhitespaces(this.myAnnotation.getProject()), new ToggleInnerMovementsWhitespaces(this.myAnnotation.getProject()), new ToggleOuterMovementsWhitespaces(this.myAnnotation.getProject()), new ToggleCommitDate()};
            }
            return AnAction.EMPTY_ARRAY;
        }
    }

    private static class ToggleOuterMovementsWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleOuterMovementsWhitespaces(@NotNull Project project) {
            super(GitBundle.message("annotations.options.detect.movements.across.files", new Object[0]));
            this.myProject = project;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (enabled) {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER);
            } else {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER);
            }
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject, true);
        }
    }

    private static class ToggleInnerMovementsWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleInnerMovementsWhitespaces(@NotNull Project project) {
            super(GitBundle.message("annotations.options.detect.movements.within.file", new Object[0]));
            this.myProject = project;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER || SETTINGS.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            if (enabled) {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER);
            } else {
                SETTINGS.setAnnotateDetectMovementsOption(GitVcsApplicationSettings.AnnotateDetectMovementsOption.NONE);
            }
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject, true);
        }
    }

    private static class ToggleIgnoreWhitespaces
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final Project myProject;

        ToggleIgnoreWhitespaces(@NotNull Project project) {
            super(GitBundle.message("annotations.options.ignore.whitespaces", new Object[0]));
            this.myProject = project;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return SETTINGS.isIgnoreWhitespaces();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            SETTINGS.setIgnoreWhitespaces(enabled);
            GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(this.myProject, true);
        }
    }

    private static final class ToggleCommitDate
    extends ToggleAction
    implements DumbAware {
        private final VcsLogApplicationSettings mySettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);

        private ToggleCommitDate() {
            super(VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.text.show", (Object[])new Object[0]), VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.description", (Object[])new Object[0]), null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.mySettings != null && Boolean.TRUE.equals(this.mySettings.get(CommonUiProperties.PREFER_COMMIT_DATE));
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (this.mySettings != null) {
                this.mySettings.set(CommonUiProperties.PREFER_COMMIT_DATE, (Object)state);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }
}

