/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitStash
extends GitRepositoryAction {
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(GitBundle.message("stash.error.can.not.stash.changes.now", new Object[0]))) {
            return;
        }
        GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        d.logUsage();
        GitStash.runStashInBackground(project, Collections.singleton(d.getGitRoot()), root -> d.handler());
    }

    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.message("stash.action.name", new Object[0]);
    }

    public static void runStashInBackground(final @NotNull Project project, final @NotNull Collection<VirtualFile> roots, final @NotNull Function<VirtualFile, GitLineHandler> createHandler) {
        new Task.Backgroundable(project, GitBundle.message("stashing.progress.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("stash.action.name", new Object[0]));){
                    ArrayList<VirtualFile> successfulRoots = new ArrayList<VirtualFile>();
                    LinkedHashMap<VirtualFile, @Nls String> failedRoots = new LinkedHashMap<VirtualFile, String>();
                    for (VirtualFile root : roots) {
                        StructuredIdeActivity activity = GitStashUsageCollector.logStashPush(project);
                        GitCommandResult result2 = Git.getInstance().runCommand((GitLineHandler)createHandler.apply(root));
                        activity.finished();
                        if (result2.success()) {
                            successfulRoots.add(root);
                            continue;
                        }
                        failedRoots.put(root, result2.getErrorOutputAsHtmlString());
                    }
                    if (!successfulRoots.isEmpty()) {
                        GitUtil.refreshVfsInRoots(successfulRoots);
                    }
                    if (!failedRoots.isEmpty()) {
                        String rootsList = StringUtil.join(failedRoots.keySet(), VirtualFile::getPresentableName, (String)",");
                        String errorTitle = GitBundle.message("stash.error", StringUtil.shortenTextWithEllipsis((String)rootsList, (int)100, (int)0));
                        String errorMessage = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(failedRoots.values(), s -> HtmlChunk.raw((String)s))).toString();
                        VcsNotifier.getInstance((Project)project).notifyError("git.stash.failed", errorTitle, errorMessage, true);
                    }
                }
            }
        }.queue();
    }
}

