/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = Objects.requireNonNull(event.getProject());
        GitVcs vcs = GitVcs.getInstance(project);
        TreeSet<VirtualFile> conflictedFiles2 = new TreeSet<VirtualFile>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file2;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file2 = before.getFile().getVirtualFile()) != null) {
                conflictedFiles2.add(file2);
            }
            if (after == null || (file2 = after.getFile().getVirtualFile()) == null) continue;
            conflictedFiles2.add(file2);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog(new ArrayList<VirtualFile>(conflictedFiles2), vcs.getMergeProvider());
    }

    private static boolean isEnabled(@NotNull Project project) {
        Collection changes = ChangeListManager.getInstance((Project)project).getAllChanges();
        if (changes.size() > 1000) {
            return true;
        }
        return changes.stream().anyMatch(it -> it.getFileStatus() == FileStatus.MERGED_WITH_CONFLICTS);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(GitResolveConflictsAction.isEnabled(project));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

