/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitRepositoryAction.getGitRoots(project, vcs);
        if (roots == null || roots.isEmpty()) {
            return;
        }
        GitRepository selectedRepo = GitBranchUtil.guessRepositoryForOperation(project, e.getDataContext());
        VirtualFile defaultRoot = selectedRepo != null ? selectedRepo.getRoot() : roots.get(0);
        this.perform(project, roots, defaultRoot);
    }

    @Nullable
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) {
        try {
            Object[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
            if (ArrayUtil.isEmpty((Object[])contentRoots)) {
                throw new VcsException(GitBundle.message("repository.action.missing.roots.unconfigured.message", new Object[0]));
            }
            Collection<GitRepository> repositories = GitUtil.getRepositories(project);
            if (repositories.isEmpty()) {
                throw new VcsException(GitBundle.message("repository.action.missing.roots.misconfigured", new Object[0]));
            }
            return DvcsUtil.sortVirtualFilesByPresentation(GitUtil.getRootsFromRepositories(repositories));
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)GitBundle.message("repository.action.missing.roots.title", new Object[0]));
            return null;
        }
    }

    @NlsActions.ActionText
    @NotNull
    protected abstract String getActionName();

    protected abstract void perform(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3);

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }
}

