/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import git4idea.merge.GitMergeOption;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMerge
extends GitMergeAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.message("merge.action.name", new Object[0]);
    }

    @Override
    @Nullable
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitMergeDialog dialog2 = new GitMergeDialog(project, defaultRoot, gitRoots);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return new GitMergeAction.DialogState(dialog2.getSelectedRoot(), GitBundle.message("merging.title", dialog2.getSelectedRoot().getPath()), this.getHandlerProvider(project, dialog2), dialog2.getSelectedBranch(), dialog2.shouldCommitAfterMerge(), ContainerUtil.map(dialog2.getSelectedOptions(), option -> option.getOption()));
    }

    @Override
    protected String getNotificationErrorDisplayId() {
        return "git.merge.failed";
    }

    @NotNull
    protected Supplier<GitLineHandler> getHandlerProvider(Project project, GitMergeDialog dialog2) {
        VirtualFile root = dialog2.getSelectedRoot();
        Set<GitMergeOption> selectedOptions = dialog2.getSelectedOptions();
        String commitMsg = dialog2.getCommitMessage().trim();
        GitBranch selectedBranch = dialog2.getSelectedBranch();
        return () -> {
            GitLineHandler h = new GitLineHandler(project, root, GitCommand.MERGE);
            for (GitMergeOption option : selectedOptions) {
                if (option == GitMergeOption.COMMIT_MESSAGE) {
                    if (commitMsg.length() <= 0) continue;
                    h.addParameters(option.getOption(), commitMsg);
                    continue;
                }
                h.addParameters(option.getOption());
            }
            h.addParameters(selectedBranch.getName());
            return h;
        };
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project != null && !GitUtil.getRepositoriesInState(project, Repository.State.MERGING).isEmpty()) {
            presentation.setEnabledAndVisible(false);
        } else if (project != null && GitUtil.getRepositoriesInState(project, Repository.State.NORMAL).isEmpty()) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
        } else {
            presentation.setEnabledAndVisible(true);
        }
    }
}

