/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.Hash;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.branch.GitBrancher;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitCreateTagAction
extends GitLogSingleCommitAction {
    protected void actionPerformed(@NotNull GitRepository repository, @NotNull Hash commit) {
        GitCreateTagAction.createNewTag(repository.getProject(), repository, commit.asString());
    }

    private static void createNewTag(@NotNull Project project, @NotNull GitRepository repository, @NotNull @NlsSafe String reference) {
        String name = Messages.showInputDialog((Project)project, (String)GitBundle.message("git.new.tag.dialog.tag.name.label", new Object[0]), (String)GitBundle.message("git.new.tag.dialog.title", reference), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return !StringUtil.isEmpty((String)inputString) && !StringUtil.containsWhitespaces((CharSequence)inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmpty((String)inputString) && !StringUtil.containsWhitespaces((CharSequence)inputString);
            }
        });
        if (name != null) {
            GitBrancher.getInstance(project).createNewTag(name, reference, Collections.singletonList(repository), null);
        }
    }
}

