/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithAction;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCompareWithTagAction
extends DvcsCompareWithAction<GitRepository> {
    protected boolean nothingToCompare(@NotNull GitRepository repository) {
        return false;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        return GitUtil.getRepositoryManager(project);
    }

    @Nullable
    protected JBPopup createPopup(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2) {
        List tags;
        try {
            tags = (List)VcsUtil.computeWithModalProgress((Project)project, (String)GitBundle.message("git.compare.with.tag.modal.progress.loading.tags", new Object[0]), (boolean)true, indicator -> GitBranchUtil.getAllTags(project, repository.getRoot()));
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)project).notifyError("git.tags.loading.failed", GitBundle.message("git.compare.with.tag.loading.error.title", new Object[0]), e.getMessage());
            return null;
        }
        return GitCompareWithTagAction.createPopup((String)GitBundle.message("git.compare.with.tag.popup.title", new Object[0]), (List)tags, selected -> GitCompareWithTagAction.showDiffWithTag(project, repository, file2, selected));
    }

    private static void showDiffWithTag(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2, @NotNull @NlsSafe String tagName) {
        String presentableRevisionName = GitCompareWithTagAction.getPresentableCurrentBranchName((Repository)repository);
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle((String)tagName, (boolean)false);
        String revNumTitle2 = VcsDiffUtil.getRevisionTitle((String)presentableRevisionName, (boolean)true);
        GitCompareWithTagAction.showDiffBetweenRevision((Project)project, (VirtualFile)file2, (String)revNumTitle1, (String)revNumTitle2, () -> GitCompareWithTagAction.getDiffChanges(project, repository, file2, tagName));
    }

    @NotNull
    private static Collection<Change> getDiffChanges(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2, @NotNull String tagName) throws VcsException {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        String refToCompare = "refs/tags/" + tagName;
        GitRevisionNumber revisionNumber = new GitRevisionNumber(refToCompare);
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, repository.getRoot(), refToCompare, Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, refToCompare) == null) {
            throw new VcsException(GitBundle.message("git.compare.with.tag.file.not.found.in.tag", file2.isDirectory() ? 2 : 1, file2.getPresentableUrl(), tagName));
        }
        ContentRevision revision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, project);
        return changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)revision) : changes;
    }
}

