/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitContentRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitCompareWithBranchAction
extends DvcsCompareWithBranchAction<GitRepository> {
    protected boolean nothingToCompare(@NotNull GitRepository repository) {
        boolean haveRemotes;
        int locals = repository.getBranches().getLocalBranches().size();
        boolean bl = haveRemotes = !repository.getBranches().getRemoteBranches().isEmpty();
        if (repository.isOnBranch()) {
            return locals < 2 && !haveRemotes;
        }
        return locals == 0 && !haveRemotes;
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull GitRepository repository) {
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(repository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        if (repository.isOnBranch()) {
            localBranches.remove(repository.getCurrentBranch());
        }
        ArrayList<String> branchNames = new ArrayList<String>();
        for (GitBranch gitBranch : localBranches) {
            branchNames.add(gitBranch.getName());
        }
        for (GitBranch gitBranch : remoteBranches) {
            branchNames.add(gitBranch.getName());
        }
        return branchNames;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        return GitUtil.getRepositoryManager(project);
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String branchName) throws VcsException {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        GitRepository gitRepository = GitUtil.getRepositoryForFile(project, file2);
        GitBranch branch = gitRepository.getBranches().findBranchByName(branchName);
        String branchToCompare = branch != null ? branch.getFullName() : branchName;
        VirtualFile gitRepositoryRoot = gitRepository.getRoot();
        GitRevisionNumber compareRevisionNumber = new GitRevisionNumber(branchToCompare);
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, gitRepositoryRoot, branchToCompare, Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, branchToCompare) == null) {
            throw new VcsException(GitCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file2, (String)branchToCompare));
        }
        ContentRevision revision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)compareRevisionNumber, project);
        return changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)revision) : changes;
    }
}

