/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.GitBranchPopup;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchesComboBoxAction
extends ComboBoxAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed() || !project.isOpen()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitRepository repo = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
        if (repo == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (!ToolbarSettings.getInstance().isAvailable()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        String branchName = repo.getCurrentRevision() != null ? GitBranchUtil.getDisplayableBranchText(repo) : GitBundle.message("no.revisions.available", new Object[0]);
        String name = DvcsBranchUtil.shortenBranchName((String)branchName);
        presentation.setText(name, false);
        presentation.setIcon(BranchIconUtil.Companion.getBranchIcon(repo));
        presentation.setEnabledAndVisible(true);
        presentation.setDescription(GitBundle.messagePointer("action.Git.ShowBranches.pretty.description", new Object[0]).get());
    }

    @NotNull
    protected ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component2, final @Nullable Runnable disposeCallback) {
        Project project = Objects.requireNonNull((Project)context.getData(CommonDataKeys.PROJECT));
        GitRepository repo = Objects.requireNonNull(GitBranchUtil.guessWidgetRepository(project, context));
        ListPopup popup2 = GitBranchPopup.getInstance(project, repo, context).asListPopup();
        popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (disposeCallback != null) {
                    disposeCallback.run();
                }
            }
        });
        return popup2;
    }
}

