/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUtil {
    @NonNls
    public static final String DOT_GIT = ".git";
    @NonNls
    public static final String COMMENT_CHAR = "\u0001";
    @NonNls
    public static final String ORIGIN_HEAD = "origin/HEAD";
    @NlsSafe
    public static final String HEAD = "HEAD";
    @NonNls
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    @NonNls
    public static final String MERGE_HEAD = "MERGE_HEAD";
    @NonNls
    public static final String REBASE_HEAD = "REBASE_HEAD";
    @NonNls
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    @NonNls
    private static final String HEAD_FILE = "HEAD";
    private static final Pattern HASH_STRING_PATTERN = Pattern.compile("[a-fA-F0-9]{40}");

    private GitUtil() {
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit = VfsUtil.refreshAndFindChild((VirtualFile)rootDir, (String)DOT_GIT);
        if (dotGit == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = VfsUtil.refreshAndFindChild((VirtualFile)dotGit, (String)"HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return null;
        }
        File file2 = GitUtil.findRealRepositoryDir(rootDir.toNioPath(), pathToDir);
        if (file2 == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file2);
    }

    @Nullable
    private static File findRealRepositoryDir(@NotNull @NonNls Path rootPath, @NotNull @NonNls String path) {
        File file2;
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath.toString(), path}), (boolean)true);
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file2 = new File(path)).isDirectory() ? file2 : null;
    }

    @Nullable
    private static String parsePathToRepository(@NotNull @NonNls String content) {
        if ((content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX)) {
            content = content.substring(REPO_PATH_LINK_PREFIX.length()).trim();
        }
        if (content.isEmpty() || content.contains("\n")) {
            return null;
        }
        return content;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    private static String readFile(@NotNull VirtualFile file2) throws IOException {
        int ATTEMPTS = 3;
        int attempt = 1;
        while (true) {
            try {
                return new String(file2.contentsToByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.info(String.format("IOException while reading %s (attempt #%s)", file2, attempt));
                if (attempt++ < 3) continue;
                throw e;
            }
            break;
        }
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) throws VcsException {
        return GitUtil.sortFilesByGitRoot(project, virtualFiles, false);
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) {
        try {
            return GitUtil.sortFilesByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            return Collections.emptyMap();
        }
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(project, filePaths, false);
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRootIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths) {
        try {
            return GitUtil.sortFilePathsByGitRoot(project, filePaths, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            return Collections.emptyMap();
        }
    }

    @NotNull
    @RequiresBackgroundThread
    private static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        Map<GitRepository, List<VirtualFile>> map2 = GitUtil.sortFilesByRepository(project, virtualFiles, ignoreNonGit);
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        map2.forEach((repo, files) -> result2.put(repo.getRoot(), (List<VirtualFile>)files));
        return result2;
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filePaths) throws VcsException {
        return GitUtil.sortFilesByRepository(project, filePaths, false);
    }

    @NotNull
    @RequiresBackgroundThread
    public static Map<GitRepository, List<VirtualFile>> sortFilesByRepositoryIgnoringMissing(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        try {
            return GitUtil.sortFilesByRepository(project, virtualFiles, true);
        }
        catch (VcsException e) {
            LOG.error((Throwable)new IllegalArgumentException(e));
            return Collections.emptyMap();
        }
    }

    @NotNull
    @RequiresBackgroundThread
    private static Map<GitRepository, List<VirtualFile>> sortFilesByRepository(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
        HashMap<GitRepository, List<VirtualFile>> result2 = new HashMap<GitRepository, List<VirtualFile>>();
        for (VirtualFile virtualFile : virtualFiles) {
            VirtualFile actualFile = virtualFile.isDirectory() ? virtualFile.getParent() : virtualFile;
            GitRepository repository = (GitRepository)manager.getRepositoryForFile(actualFile);
            if (repository == null) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(virtualFile);
            }
            List files = result2.computeIfAbsent(repository, key -> new ArrayList());
            files.add(virtualFile);
        }
        return result2;
    }

    @NotNull
    private static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Project project, @NotNull Collection<? extends FilePath> filePaths, boolean ignoreNonGit) throws VcsException {
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        GitVcs gitVcs = GitVcs.getInstance(project);
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath filePath : filePaths) {
            AbstractVcs vcs;
            VcsRoot vcsRoot = manager.getVcsRootObjectFor(filePath);
            AbstractVcs abstractVcs = vcs = vcsRoot != null ? vcsRoot.getVcs() : null;
            if (vcs == null || !vcs.equals((Object)gitVcs)) {
                if (ignoreNonGit) continue;
                throw new GitRepositoryNotFoundException(filePath);
            }
            List paths = result2.computeIfAbsent(vcsRoot.getPath(), key -> new ArrayList());
            paths.add(filePath);
        }
        return result2;
    }

    public static Date parseTimestamp(@NonNls String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(@NonNls String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    @Nullable
    public static VirtualFile findGitRootFor(@NotNull Path path) {
        try {
            for (Path root = path; root != null; root = root.getParent()) {
                if (!GitUtil.isGitRoot(root)) continue;
                return LocalFileSystem.getInstance().findFileByNioFile(root);
            }
            return null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    public static boolean isGitRoot(@NotNull File folder) {
        try {
            return GitUtil.isGitRoot(folder.toPath());
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    public static boolean isUnderGit(@NotNull VirtualFile vFile) {
        try {
            return GitUtil.findGitRootFor(vFile.toNioPath()) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    public static boolean isUnderGit(@NotNull FilePath path) {
        try {
            return GitUtil.findGitRootFor(Paths.get(path.getPath(), new String[0])) != null;
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    @NlsSafe
    public static String adjustAuthorName(@NlsSafe String authorName, @NlsSafe String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = GitBundle.message("commit.author.with.committer", authorName, committerName);
        }
        return committerName;
    }

    @NotNull
    @RequiresBackgroundThread
    public static Set<GitRepository> getRepositoriesForFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) throws VcsException {
        HashSet<GitRepository> result2 = new HashSet<GitRepository>();
        for (VirtualFile virtualFile : files) {
            result2.add(GitUtil.getRepositoryForFile(project, virtualFile));
        }
        return result2;
    }

    @NonNls
    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    @NonNls
    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier, Consumer<? super GitCommittedChangeList> consumer2, boolean skipDiffsForMerge) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer2.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer2.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is available: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull @NonNls String path) throws VcsException {
        try {
            return VcsFileUtil.unescapeGitPath((String)path);
        }
        catch (IllegalStateException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        return !manager.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull @NonNls String name) {
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull @NonNls String name) {
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull @NonNls String nameAtRemote) {
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), remoteBranch -> remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote)));
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull @NonNls String branchName) {
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        return (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        return ContainerUtil.map(repositories, Repository::getRoot);
    }

    @NotNull
    @RequiresBackgroundThread
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<? extends VirtualFile> roots) {
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile virtualFile : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(virtualFile);
            if (repo == null) {
                LOG.error("Repository not found for root " + virtualFile);
                continue;
            }
            repositories.add(repo);
        }
        return repositories;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull @NonNls String beforeRef, @NotNull @NonNls String afterRef) throws VcsException {
        String range;
        List<String> parameters = Arrays.asList("--name-only", "--pretty=format:");
        GitCommandResult result2 = git.diff(repository, parameters, range = beforeRef + ".." + afterRef);
        if (!result2.success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            return Collections.emptyList();
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        return remoteChanges;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        return GitRepositoryManager.getInstance(project);
    }

    @NotNull
    @RequiresBackgroundThread
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull VirtualFile file2) throws VcsException {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file2);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(file2);
        }
        return repository;
    }

    @NotNull
    @RequiresBackgroundThread
    public static GitRepository getRepositoryForFile(@NotNull Project project, @NotNull FilePath file2) throws VcsException {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file2);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(file2);
        }
        return repository;
    }

    @NotNull
    @RequiresBackgroundThread
    public static GitRepository getRepositoryForRoot(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        if (repository == null) {
            throw new GitRepositoryNotFoundException(root);
        }
        return repository;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error((Throwable)((Object)new GitRepositoryNotFoundException(root)));
        }
        return repository;
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        VcsRoot root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(filePath);
        if (GitUtil.isGitVcsRoot(root)) {
            return root.getPath();
        }
        Repository repository = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(filePath);
        if (repository instanceof GitRepository) {
            return repository.getRoot();
        }
        throw new GitRepositoryNotFoundException(filePath);
    }

    @NotNull
    public static VirtualFile getRootForFile(@NotNull Project project, @NotNull VirtualFile file2) throws VcsException {
        VcsRoot root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(file2);
        if (GitUtil.isGitVcsRoot(root)) {
            return root.getPath();
        }
        Repository repository = VcsRepositoryManager.getInstance((Project)project).getExternalRepositoryForFile(file2);
        if (repository instanceof GitRepository) {
            return repository.getRoot();
        }
        throw new GitRepositoryNotFoundException(file2);
    }

    private static boolean isGitVcsRoot(@Nullable VcsRoot root) {
        if (root == null) {
            return false;
        }
        AbstractVcs vcs = root.getVcs();
        if (vcs == null) {
            return false;
        }
        return GitVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    public static void showSubmittedFiles(final Project project, final @NonNls String revision, final VirtualFile file2, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getRootForFile(project, file2);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, GitBundle.message("operation.name.loading.revision", new Object[0])));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        diff.addParameters("--no-renames");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull @NonNls String absolutePath) {
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(absolutePath);
        if (file2 == null) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file2 == null) {
            LOG.debug("VirtualFile not found for " + absolutePath);
        }
        return file2;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull @NonNls String relativePath) {
        return StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<@NonNls String> relativePaths) {
        return ContainerUtil.map(relativePaths, s -> GitUtil.toAbsolute(root, s));
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<@NonNls String> affectedPaths, boolean relativePaths) {
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file2 = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file2 == null) continue;
            Change change = changeListManager.getChange(file2);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file2.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
            }
            LOG.debug(message);
        }
        return affectedChanges;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<@NonNls String> absolutePaths, @NotNull @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.DialogMessage String description2) {
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description2 != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description2));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NlsSafe
    @NotNull
    public static String cleanupErrorPrefixes(@NotNull @NlsSafe String msg) {
        @NonNls String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        return msg;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        return (GitRemote)ContainerUtil.find(remotes, r -> r.getName().equals("origin"));
    }

    @Nullable
    public static GitRemote getDefaultOrFirstRemote(@NotNull Collection<GitRemote> remotes) {
        GitRemote result2 = GitUtil.getDefaultRemote(remotes);
        return result2 == null ? (GitRemote)ContainerUtil.getFirstItem(remotes) : result2;
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<? extends GitRepository> repositories) {
        return StringUtil.join(repositories, repository -> repository.getPresentableUrl(), (String)"<br/>");
    }

    @Nls
    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        return GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? GitBundle.message("mention.in", DvcsUtil.getShortRepositoryName((Repository)repository)) : "";
    }

    @Nls
    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories.isEmpty()) {
            return "";
        }
        return GitBundle.message("mention.in", DvcsUtil.joinShortNames(repositories, (int)-1));
    }

    public static void updateRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        for (GitRepository gitRepository : repositories) {
            gitRepository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        return GitUtil.getRepositoryManager(project).getRepositories();
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesInState(@NotNull Project project, @NotNull Repository.State state) {
        return ContainerUtil.filter(GitUtil.getRepositories(project), repository -> repository.getState() == state);
    }

    public static boolean isCaseOnlyChange(@NotNull @NonNls String oldPath, @NotNull @NonNls String newPath) {
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NonNls
    @NotNull
    public static String getLogStringGitDiffChanges(@NotNull @NonNls String root, @NotNull Collection<? extends GitChangeUtils.GitDiffChange> changes) {
        return GitUtil.getLogString(root, changes, it -> it.getBeforePath(), it -> it.getAfterPath());
    }

    @NonNls
    @NotNull
    public static String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends Change> changes) {
        return GitUtil.getLogString(root, changes, ChangesUtil::getBeforePath, ChangesUtil::getAfterPath);
    }

    @NonNls
    @NotNull
    public static <T> String getLogString(@NotNull @NonNls String root, @NotNull Collection<? extends T> changes, @NotNull Convertor<? super T, ? extends FilePath> beforePathGetter, @NotNull Convertor<? super T, ? extends FilePath> afterPathGetter) {
        return StringUtil.join(changes, change -> {
            FilePath after = (FilePath)afterPathGetter.convert(change);
            FilePath before = (FilePath)beforePathGetter.convert(change);
            if (before == null) {
                return "A: " + GitUtil.getRelativePath(root, after);
            }
            if (after == null) {
                return "D: " + GitUtil.getRelativePath(root, before);
            }
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)before, (Object)after)) {
                return "M: " + GitUtil.getRelativePath(root, after);
            }
            return "R: " + GitUtil.getRelativePath(root, before) + " -> " + GitUtil.getRelativePath(root, after);
        }, (String)", ");
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull FilePath after) {
        return FileUtil.getRelativePath((String)root, (String)after.getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        ObjectOpenHashSet allChanges = new ObjectOpenHashSet(changeListManager.getAllChanges());
        return ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((ObjectOpenHashSet)allChanges).get(arg_0));
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<? extends Change> changes) {
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            GitUtil.refreshVfsInRoot(root);
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
        }
    }

    public static void refreshVfsInRoot(@NotNull VirtualFile root) {
        GitUtil.refreshVfsInRoots(Collections.singleton(root));
    }

    public static void refreshVfsInRoots(@NotNull Collection<VirtualFile> roots) {
        RefreshVFsSynchronously.trace((String)("refresh roots " + roots));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY));
    }

    public static void updateAndRefreshChangedVfs(@NotNull GitRepository repository, @Nullable Hash startHash) {
        repository.update();
        GitUtil.refreshChangedVfs(repository, startHash);
    }

    public static void refreshChangedVfs(@NotNull GitRepository repository, @Nullable Hash startHash) {
        Hash currentHash;
        Collection<Change> changes = null;
        if (startHash != null && (currentHash = GitUtil.getHead(repository)) != null) {
            RefreshVFsSynchronously.trace((String)String.format("changes: %s -> %s", startHash.asString(), currentHash.asString()));
            changes = GitChangeUtils.getDiff(repository, startHash.asString(), currentHash.asString(), false);
        }
        GitUtil.refreshVfs(repository.getRoot(), changes);
    }

    public static boolean isGitRoot(@NotNull @NonNls String rootDir) {
        try {
            return GitUtil.isGitRoot(Paths.get(rootDir, new String[0]));
        }
        catch (InvalidPathException e) {
            LOG.warn(e.getMessage());
            return false;
        }
    }

    public static boolean isGitRoot(@NotNull Path rootDir) {
        String content;
        BasicFileAttributes attributes;
        Path dotGit = rootDir.resolve(DOT_GIT);
        try {
            attributes = Files.readAttributes(dotGit, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ignore) {
            return false;
        }
        if (attributes.isDirectory()) {
            try {
                BasicFileAttributes headExists = Files.readAttributes(dotGit.resolve("HEAD"), BasicFileAttributes.class, new LinkOption[0]);
                return headExists.isRegularFile();
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (!attributes.isRegularFile()) {
            return false;
        }
        try {
            content = (String)DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)Files.readString(dotGit)).trim(), (Object)dotGit);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return false;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        if (pathToDir == null) {
            return false;
        }
        return GitUtil.findRealRepositoryDir(rootDir, pathToDir) != null;
    }

    public static void generateGitignoreFileIfNeeded(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        VcsImplUtil.generateIgnoreFileIfNeeded((Project)project, (AbstractVcs)GitVcs.getInstance(project), (VirtualFile)ignoreFileRoot);
    }

    public static <T extends Throwable> void tryRunOrClose(@NotNull AutoCloseable closeable, @NotNull ThrowableRunnable<T> runnable) throws T {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            try {
                closeable.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @NotNull
    public static <T extends GitHandler> T createHandlerWithPaths(@Nullable Collection<? extends FilePath> paths, @NotNull Computable<T> handlerBuilder) {
        GitHandler handler = (GitHandler)handlerBuilder.compute();
        handler.endOptions();
        if (paths != null) {
            handler.addRelativePaths(paths);
            if (handler.isLargeCommandLine()) {
                handler = (GitHandler)handlerBuilder.compute();
                handler.endOptions();
            }
        }
        return (T)handler;
    }

    @Nullable
    public static Hash getHead(@NotNull GitRepository repository) {
        GitCommandResult result2 = Git.getInstance().tip(repository, "HEAD");
        if (!result2.success()) {
            LOG.warn("Couldn't identify the HEAD for " + repository + ": " + result2.getErrorOutputAsJoinedString());
            return null;
        }
        String head = result2.getOutputAsJoinedString();
        return HashImpl.build((String)head);
    }

    public static boolean isHashString(@NotNull @NonNls String revision) {
        return HASH_STRING_PATTERN.matcher(revision).matches();
    }

    private static final class GitRepositoryNotFoundException
    extends VcsException {
        private GitRepositoryNotFoundException(@NotNull VirtualFile file2) {
            super(GitBundle.message("repository.not.found.error", file2.getPresentableUrl()));
        }

        private GitRepositoryNotFoundException(@NotNull FilePath filePath) {
            super(GitBundle.message("repository.not.found.error", filePath.getPresentableUrl()));
        }
    }
}

