/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitUserRegistry
implements Disposable,
VcsMappingListener {
    private static final Logger LOG = Logger.getInstance(GitUserRegistry.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, VcsUser> myUserMap = new ConcurrentHashMap<VirtualFile, VcsUser>();

    public GitUserRegistry(@NotNull Project project) {
        this.myProject = project;
    }

    public static GitUserRegistry getInstance(@NotNull Project project) {
        return (GitUserRegistry)project.getService(GitUserRegistry.class);
    }

    public void activate() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.directoryMappingChanged();
    }

    @Nullable
    public VcsUser getUser(@NotNull VirtualFile root) {
        return this.myUserMap.get(root);
    }

    @Nullable
    public VcsUser getOrReadUser(@NotNull VirtualFile root) {
        VcsUser user = this.myUserMap.get(root);
        if (user == null) {
            try {
                user = GitUserRegistry.readCurrentUser(this.myProject, root);
                if (user != null) {
                    this.myUserMap.put(root, user);
                }
            }
            catch (VcsException e) {
                LOG.warn("Could not retrieve user name in " + root, (Throwable)e);
            }
        }
        return user;
    }

    @Nullable
    private static VcsUser readCurrentUser(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        String userName = GitConfigUtil.getValue(project, root, "user.name");
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(project, root, "user.email"));
        return userName == null ? null : ((VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class)).createUser(userName, userEmail);
    }

    public void dispose() {
        this.myUserMap.clear();
    }

    public void directoryMappingChanged() {
        Object[] roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(this.myProject));
        List rootsToCheck = ContainerUtil.filter((Object[])roots, root -> this.getUser((VirtualFile)root) == null);
        if (!rootsToCheck.isEmpty()) {
            Runnable task = () -> {
                for (VirtualFile root : rootsToCheck) {
                    this.getOrReadUser(root);
                }
            };
            BackgroundTaskUtil.executeOnPooledThread((Disposable)this, (Runnable)task);
        }
    }
}

