/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;
import org.jetbrains.annotations.NotNull;

public final class GitStandardRemoteBranch
extends GitRemoteBranch {
    @NotNull
    private final GitRemote myRemote;
    @NotNull
    private final String myNameAtRemote;

    public GitStandardRemoteBranch(@NotNull GitRemote remote, @NotNull String nameAtRemote) {
        super(GitStandardRemoteBranch.formStandardName(remote, GitBranchUtil.stripRefsPrefix(nameAtRemote)));
        this.myRemote = remote;
        this.myNameAtRemote = GitBranchUtil.stripRefsPrefix(nameAtRemote);
    }

    @NotNull
    private static String formStandardName(@NotNull GitRemote remote, @NotNull String nameAtRemote) {
        return remote.getName() + "/" + nameAtRemote;
    }

    @Override
    @NotNull
    public GitRemote getRemote() {
        return this.myRemote;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitStandardRemoteBranch branch = (GitStandardRemoteBranch)o;
        if (!this.myNameAtRemote.equals(branch.myNameAtRemote)) {
            return false;
        }
        return this.myRemote.equals(branch.myRemote);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myRemote.hashCode();
        result2 = 31 * result2 + this.myNameAtRemote.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public String getNameForRemoteOperations() {
        return this.myNameAtRemote;
    }

    @Override
    @NotNull
    public String getNameForLocalOperations() {
        return this.myName;
    }

    @Override
    public int compareTo(GitReference o) {
        if (o instanceof GitStandardRemoteBranch) {
            return StringUtil.compare((String)this.myName, (String)o.myName, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }
        return super.compareTo(o);
    }
}

