/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J*\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0017"}, d2={"Lgit4idea/GitPushUtil;", "", "()V", "findOrPushRemoteBranch", "Ljava/util/concurrent/CompletableFuture;", "Lgit4idea/GitRemoteBranch;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "localBranch", "Lgit4idea/GitLocalBranch;", "dialogMessages", "Lgit4idea/GitPushUtil$BranchNameInputDialogMessages;", "findPushTarget", "Lgit4idea/push/GitPushTarget;", "branch", "inputPushTarget", "BranchNameInputDialogMessages", "intellij.vcs.git"})
public final class GitPushUtil {
    @NotNull
    public static final GitPushUtil INSTANCE = new GitPushUtil();

    private GitPushUtil() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<GitRemoteBranch> findOrPushRemoteBranch(@NotNull Project project, @NotNull ProgressIndicator progressIndicator, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch localBranch, @NotNull BranchNameInputDialogMessages dialogMessages) {
        Hash remoteHash;
        Hash localHash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)localBranch, (String)"localBranch");
        Intrinsics.checkNotNullParameter((Object)dialogMessages, (String)"dialogMessages");
        PushSupport pushSupport = DvcsUtil.getPushSupport((AbstractVcs)GitVcs.getInstance(project));
        GitPushSupport gitPushSupport = pushSupport instanceof GitPushSupport ? (GitPushSupport)pushSupport : null;
        if (gitPushSupport == null) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.failedFuture((Throwable)new ProcessCanceledException());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(ProcessCanceledException())");
            return completableFuture;
        }
        GitPushSupport gitPushSupport2 = gitPushSupport;
        GitPushTarget existingPushTarget = GitPushUtil.findPushTarget(repository, remote, localBranch);
        if (existingPushTarget != null && Intrinsics.areEqual((Object)(localHash = repository.getBranches().getHash(localBranch)), (Object)(remoteHash = repository.getBranches().getHash(existingPushTarget.getBranch())))) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.completedFuture(existingPushTarget.getBranch());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(existingPushTarget.branch)");
            return completableFuture;
        }
        GitPushTarget gitPushTarget = existingPushTarget;
        if (gitPushTarget == null && (gitPushTarget = INSTANCE.inputPushTarget(repository, remote, localBranch, dialogMessages)) == null) {
            CompletableFuture<GitRemoteBranch> completableFuture = CompletableFuture.failedFuture((Throwable)new ProcessCanceledException());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(ProcessCanceledException())");
            return completableFuture;
        }
        GitPushTarget pushTarget = gitPushTarget;
        CompletableFuture<GitRemoteBranch> future2 = new CompletableFuture<GitRemoteBranch>();
        Project project2 = repository.getProject();
        String string = DvcsBundle.message((String)"push.process.pushing", (Object[])new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(localBranch, pushTarget, repository, gitPushSupport2, future2, project2, string){
            final /* synthetic */ GitLocalBranch $localBranch;
            final /* synthetic */ GitPushTarget $pushTarget;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitPushSupport $gitPushSupport;
            final /* synthetic */ CompletableFuture<GitRemoteBranch> $future;
            {
                this.$localBranch = $localBranch;
                this.$pushTarget = $pushTarget;
                this.$repository = $repository;
                this.$gitPushSupport = $gitPushSupport;
                this.$future = $future;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DvcsBundle.message((String)"push.process.pushing", (Object[])new Object[0]));
                PushSpec pushSpec = new PushSpec((PushSource)GitPushSource.create(this.$localBranch), (PushTarget)this.$pushTarget);
                GitPushRepoResult gitPushRepoResult = new GitPushOperation(this.$repository.getProject(), this.$gitPushSupport, (Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>>)MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$repository, (Object)pushSpec)), null, false, false).execute().getResults().get(this.$repository);
                if (gitPushRepoResult == null) {
                    throw new IllegalStateException("Missing push result".toString());
                }
                GitPushRepoResult pushResult = gitPushRepoResult;
                if (!(pushResult.getError() == null)) {
                    boolean bl = false;
                    Object[] objectArray = new Object[1];
                    String string = pushResult.getError();
                    if (string == null) {
                        string = "";
                    }
                    objectArray[0] = string;
                    String string2 = GitBundle.message("push.failed.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"push.failed.err\u2026shResult.error.orEmpty())");
                    String string3 = string2;
                    throw new IllegalStateException(string3.toString());
                }
            }

            public void onSuccess() {
                this.$future.complete(this.$pushTarget.getBranch());
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$future.completeExceptionally(error);
            }

            public void onCancel() {
                this.$future.completeExceptionally((Throwable)new ProcessCanceledException());
            }
        }, progressIndicator);
        return future2;
    }

    private final GitPushTarget inputPushTarget(GitRepository repository, GitRemote remote, GitLocalBranch localBranch, BranchNameInputDialogMessages dialogMessages) {
        String string = MessagesService.Companion.getInstance().showInputDialog(repository.getProject(), null, dialogMessages.getInputMessage(), dialogMessages.getTitle(), null, localBranch.getName(), null, null, dialogMessages.getInputComment());
        if (string == null) {
            return null;
        }
        String branchName = string;
        return new GitPushTarget(new GitStandardRemoteBranch(remote, GitRefNameValidator.getInstance().cleanUpBranchName(branchName)), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final GitPushTarget findPushTarget(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch branch) {
        GitBranchTrackInfo gitBranchTrackInfo;
        GitBranchTrackInfo gitBranchTrackInfo2;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitPushTarget gitPushTarget = GitPushTarget.getFromPushSpec(repository, remote, branch);
        GitPushTarget gitPushTarget2 = gitPushTarget;
        if (gitPushTarget != null) return gitPushTarget2;
        GitBranchTrackInfo gitBranchTrackInfo3 = GitBranchUtil.getTrackInfoForBranch(repository, branch);
        if (gitBranchTrackInfo3 == null) return null;
        GitBranchTrackInfo it = gitBranchTrackInfo2 = gitBranchTrackInfo3;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getRemote(), (Object)remote)) return null;
        GitBranchTrackInfo gitBranchTrackInfo4 = gitBranchTrackInfo2;
        GitBranchTrackInfo gitBranchTrackInfo5 = gitBranchTrackInfo4;
        if (gitBranchTrackInfo5 == null) return null;
        GitBranchTrackInfo it2 = gitBranchTrackInfo = gitBranchTrackInfo5;
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)it2.getRemoteBranch().getNameForRemoteOperations(), (Object)branch.getName())) return null;
        GitBranchTrackInfo gitBranchTrackInfo6 = gitBranchTrackInfo;
        gitBranchTrackInfo2 = gitBranchTrackInfo6;
        if (gitBranchTrackInfo2 == null) return null;
        it2 = gitBranchTrackInfo2;
        boolean bl3 = false;
        gitPushTarget2 = new GitPushTarget(it2.getRemoteBranch(), false);
        return gitPushTarget2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lgit4idea/GitPushUtil$BranchNameInputDialogMessages;", "", "title", "", "inputMessage", "inputComment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getInputComment", "()Ljava/lang/String;", "getInputMessage", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class BranchNameInputDialogMessages {
        @NotNull
        private final String title;
        @NotNull
        private final String inputMessage;
        @NotNull
        private final String inputComment;

        public BranchNameInputDialogMessages(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String inputMessage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String inputComment) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)inputMessage, (String)"inputMessage");
            Intrinsics.checkNotNullParameter((Object)inputComment, (String)"inputComment");
            this.title = title;
            this.inputMessage = inputMessage;
            this.inputComment = inputComment;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getInputMessage() {
            return this.inputMessage;
        }

        @NotNull
        public final String getInputComment() {
            return this.inputComment;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.inputMessage;
        }

        @NotNull
        public final String component3() {
            return this.inputComment;
        }

        @NotNull
        public final BranchNameInputDialogMessages copy(@NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String inputMessage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String inputComment) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)inputMessage, (String)"inputMessage");
            Intrinsics.checkNotNullParameter((Object)inputComment, (String)"inputComment");
            return new BranchNameInputDialogMessages(title, inputMessage, inputComment);
        }

        public static /* synthetic */ BranchNameInputDialogMessages copy$default(BranchNameInputDialogMessages branchNameInputDialogMessages, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchNameInputDialogMessages.title;
            }
            if ((n & 2) != 0) {
                string2 = branchNameInputDialogMessages.inputMessage;
            }
            if ((n & 4) != 0) {
                string3 = branchNameInputDialogMessages.inputComment;
            }
            return branchNameInputDialogMessages.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "BranchNameInputDialogMessages(title=" + this.title + ", inputMessage=" + this.inputMessage + ", inputComment=" + this.inputComment + ")";
        }

        public int hashCode() {
            int result2 = this.title.hashCode();
            result2 = result2 * 31 + this.inputMessage.hashCode();
            result2 = result2 * 31 + this.inputComment.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchNameInputDialogMessages)) {
                return false;
            }
            BranchNameInputDialogMessages branchNameInputDialogMessages = (BranchNameInputDialogMessages)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)branchNameInputDialogMessages.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputMessage, (Object)branchNameInputDialogMessages.inputMessage)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.inputComment, (Object)branchNameInputDialogMessages.inputComment);
        }
    }
}

