/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitLocalBranch
extends GitBranch {
    public GitLocalBranch(@NotNull String name) {
        super(name);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Nullable
    public GitRemoteBranch findTrackedBranch(@NotNull GitRepository repository) {
        GitBranchTrackInfo info = GitBranchUtil.getTrackInfoForBranch(repository, this);
        return info != null ? info.getRemoteBranch() : null;
    }

    @Override
    public int compareTo(GitReference o) {
        if (o instanceof GitLocalBranch) {
            return StringUtil.compare((String)this.myName, (String)o.myName, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }
        return super.compareTo(o);
    }
}

