/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.util.GitFileUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileRevision
extends VcsFileRevisionEx
implements Comparable<VcsFileRevision> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final GitRevisionNumber myRevision;
    @Nullable
    private final Couple<Couple<String>> myAuthorAndCommitter;
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myBranch;
    @Nullable
    private final Date myAuthorTime;
    @NotNull
    private final Collection<String> myParents;
    @Nullable
    private final VirtualFile myRoot;
    private final boolean myIsDeleted;

    public GitFileRevision(@NotNull Project project, @NotNull FilePath path, @NotNull GitRevisionNumber revision) {
        this(project, null, path, revision);
    }

    public GitFileRevision(@NotNull Project project, @Nullable VirtualFile root, @NotNull FilePath path, @NotNull GitRevisionNumber revision) {
        this(project, root, path, revision, null, null, null, null, Collections.emptyList(), false);
    }

    public GitFileRevision(@NotNull Project project, @Nullable VirtualFile root, @NotNull FilePath path, @NotNull GitRevisionNumber revision, @Nullable Couple<Couple<String>> authorAndCommitter, @Nullable String message, @Nullable String branch, @Nullable Date authorTime, @NotNull Collection<String> parents, boolean isDeleted) {
        this.myProject = project;
        this.myRoot = root;
        this.myPath = path;
        this.myRevision = revision;
        this.myAuthorAndCommitter = authorAndCommitter;
        this.myMessage = message;
        this.myBranch = branch;
        this.myAuthorTime = authorTime;
        this.myParents = parents;
        this.myIsDeleted = isDeleted;
    }

    @NotNull
    public FilePath getPath() {
        return this.myPath;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public Date getRevisionDate() {
        return this.myRevision.getTimestamp();
    }

    @Nullable
    public Date getAuthorDate() {
        return this.myAuthorTime;
    }

    @Nullable
    public String getAuthor() {
        return (String)Pair.getFirst((Pair)((Pair)Pair.getFirst(this.myAuthorAndCommitter)));
    }

    @Nullable
    public String getAuthorEmail() {
        return (String)Pair.getSecond((Pair)((Pair)Pair.getFirst(this.myAuthorAndCommitter)));
    }

    @Nullable
    public String getCommitterName() {
        return (String)Pair.getFirst((Pair)((Pair)Pair.getSecond(this.myAuthorAndCommitter)));
    }

    @Nullable
    public String getCommitterEmail() {
        return (String)Pair.getSecond((Pair)((Pair)Pair.getSecond(this.myAuthorAndCommitter)));
    }

    @Nullable
    public String getCommitMessage() {
        return this.myMessage;
    }

    @Nullable
    public String getBranchName() {
        return this.myBranch;
    }

    public synchronized byte @NotNull [] loadContent() throws VcsException {
        VirtualFile root = this.myRoot != null ? this.myRoot : GitUtil.getRootForFile(this.myProject, this.myPath);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myPath));
    }

    public synchronized byte[] getContent() throws VcsException {
        return this.loadContent();
    }

    @Override
    public int compareTo(VcsFileRevision rev) {
        if (rev instanceof GitFileRevision) {
            return this.myRevision.compareTo((VcsRevisionNumber)((GitFileRevision)rev).myRevision);
        }
        return this.getRevisionDate().compareTo(rev.getRevisionDate());
    }

    public String toString() {
        return this.myPath.getName() + ":" + this.myRevision.getShortRev();
    }

    @NotNull
    public Collection<String> getParents() {
        return this.myParents;
    }

    @NotNull
    public String getHash() {
        return this.myRevision.getRev();
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }
}

