/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.history.GitCommitRequirements;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class GitCommit
extends VcsChangesLazilyParsedDetails {
    @NotNull
    private final GitCommitRequirements myRequirements;

    public GitCommit(@NotNull Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<VcsFileStatusInfo>> reportedChanges, @NotNull GitCommitRequirements requirements) {
        super(project, hash, parents, commitTime, root, subject, author, message, committer, authorTime, reportedChanges, (VcsChangesLazilyParsedDetails.ChangesParser)new GitChangesParser());
        this.myRequirements = requirements;
    }

    @ApiStatus.Internal
    @NotNull
    public Set<FilePath> getAffectedPaths() {
        VcsChangesLazilyParsedDetails.Changes changesObject = this.getChangesObject();
        if (changesObject instanceof VcsChangesLazilyParsedDetails.UnparsedChanges) {
            HashSet<FilePath> result2 = new HashSet<FilePath>();
            for (VcsFileStatusInfo statusInfo : ((VcsChangesLazilyParsedDetails.UnparsedChanges)changesObject).getMergedStatuses()) {
                result2.add(GitContentRevision.createPath(this.getRoot(), statusInfo.getFirstPath()));
                String secondPath = statusInfo.getSecondPath();
                if (secondPath == null) continue;
                result2.add(GitContentRevision.createPath(this.getRoot(), secondPath));
            }
            return result2;
        }
        HashSet<FilePath> result3 = new HashSet<FilePath>();
        for (Change change : this.getChanges()) {
            FilePath afterPath;
            FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
            if (beforePath != null) {
                result3.add(beforePath);
            }
            if ((afterPath = ChangesUtil.getAfterPath((Change)change)) == null) continue;
            result3.add(afterPath);
        }
        return result3;
    }

    @NotNull
    public GitCommitRequirements getRequirements() {
        return this.myRequirements;
    }

    private static class GitChangesParser
    implements VcsChangesLazilyParsedDetails.ChangesParser {
        private GitChangesParser() {
        }

        public List<Change> parseStatusInfo(@NotNull Project project, @NotNull VcsShortCommitDetails commit, @NotNull List<VcsFileStatusInfo> changes, int parentIndex) {
            String parentHash = null;
            if (parentIndex < commit.getParents().size()) {
                parentHash = ((Hash)commit.getParents().get(parentIndex)).asString();
            }
            return git4idea.history.GitChangesParser.parse(project, commit.getRoot(), changes, ((Hash)commit.getId()).asString(), new Date(commit.getCommitTime()), parentHash);
        }
    }
}

